/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import io.netty.channel.EventLoopGroup;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.ClientPool;
import tech.ytsaurus.client.ErrorHandlingClient;
import tech.ytsaurus.client.HostPort;
import tech.ytsaurus.client.HttpProxyGetter;
import tech.ytsaurus.client.ProxyGetter;
import tech.ytsaurus.client.RpcClientFactory;
import tech.ytsaurus.client.RpcProxyGetter;
import tech.ytsaurus.client.SelfCheckingClientFactoryImpl;
import tech.ytsaurus.client.discovery.Discoverer;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
class ClientPoolService
extends ClientPool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClientPoolService.class);
    final ProxyGetter proxyGetter;
    final ScheduledExecutorService executorService;
    final long updatePeriodMs;
    final List<AutoCloseable> toClose = new ArrayList<AutoCloseable>();
    State state = State.NOT_STARTED;
    Future<?> nextUpdate = new CompletableFuture();

    private ClientPoolService(HttpBuilder httpBuilder) {
        super(Objects.requireNonNull(httpBuilder.dataCenterName), Objects.requireNonNull(httpBuilder.options).getChannelPoolSize(), new SelfCheckingClientFactoryImpl(Objects.requireNonNull(httpBuilder.clientFactory), httpBuilder.options), (ExecutorService)Objects.requireNonNull(httpBuilder.eventLoop), Objects.requireNonNull(httpBuilder.random), Objects.requireNonNull(httpBuilder.options.getRpcProxySelector()));
        HttpClient httpClient = HttpClient.newBuilder().executor((Executor)httpBuilder.eventLoop).build();
        this.proxyGetter = new HttpProxyGetter(httpClient, httpBuilder);
        this.executorService = httpBuilder.eventLoop;
        this.updatePeriodMs = httpBuilder.options.getProxyUpdateTimeout().toMillis();
    }

    private ClientPoolService(RpcBuilder rpcBuilder) {
        super(Objects.requireNonNull(rpcBuilder.dataCenterName), Objects.requireNonNull(rpcBuilder.options).getChannelPoolSize(), new SelfCheckingClientFactoryImpl(Objects.requireNonNull(rpcBuilder.clientFactory), rpcBuilder.options), (ExecutorService)Objects.requireNonNull(rpcBuilder.eventLoop), Objects.requireNonNull(rpcBuilder.random), Objects.requireNonNull(rpcBuilder.options.getRpcProxySelector()));
        this.proxyGetter = new RpcProxyGetter(Objects.requireNonNull(rpcBuilder.initialProxyList), this, rpcBuilder.role, rpcBuilder.dataCenterName, rpcBuilder.clientFactory, rpcBuilder.options, rpcBuilder.random);
        this.executorService = rpcBuilder.eventLoop;
        this.updatePeriodMs = rpcBuilder.options.getProxyUpdateTimeout().toMillis();
        this.updateClients(rpcBuilder.initialProxyList);
    }

    private ClientPoolService(DiscoveryClientPoolBuilder discoveryBuilder) {
        super("discovery-server", Objects.requireNonNull(discoveryBuilder.options).getChannelPoolSize(), (hostPort, name, statusFuture) -> {
            RpcClient client = Objects.requireNonNull(discoveryBuilder.clientFactory).create(hostPort, name);
            return new ErrorHandlingClient(client, statusFuture);
        }, (ExecutorService)Objects.requireNonNull(discoveryBuilder.eventLoop), Objects.requireNonNull(discoveryBuilder.random));
        Discoverer discoverer = Objects.requireNonNull(discoveryBuilder.discoverer);
        this.proxyGetter = () -> {
            List servers = discoverer.listDiscoveryServers().stream().map(HostPort::parse).collect(Collectors.toList());
            return CompletableFuture.completedFuture(servers);
        };
        this.executorService = discoveryBuilder.eventLoop;
        this.updatePeriodMs = discoveryBuilder.options.getProxyUpdateTimeout().toMillis();
    }

    static HttpBuilder httpBuilder() {
        return new HttpBuilder();
    }

    static RpcBuilder rpcBuilder() {
        return new RpcBuilder();
    }

    static DiscoveryClientPoolBuilder discoveryClientPoolBuilder() {
        return new DiscoveryClientPoolBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        ClientPoolService clientPoolService = this;
        synchronized (clientPoolService) {
            if (this.state != State.NOT_STARTED) {
                throw new IllegalArgumentException("ClientPoolService is in invalid state: " + String.valueOf((Object)this.state));
            }
            this.state = State.RUNNING;
            this.setOnAllBannedCallback(() -> this.doUpdate(false));
            this.nextUpdate = this.executorService.submit(() -> this.doUpdate(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ClientPoolService clientPoolService = this;
        synchronized (clientPoolService) {
            this.state = State.STOPPED;
            this.nextUpdate.cancel(true);
        }
        Throwable error = null;
        for (AutoCloseable closable : this.toClose) {
            try {
                closable.close();
            }
            catch (Throwable t) {
                logger.error("Error while closing client pool service", t);
                error = t;
            }
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    private void doUpdate(boolean scheduleNextUpdate) {
        logger.debug("Discover rpc proxies DataCenter: {}", (Object)this.getDataCenterName());
        long startUpdateTime = System.currentTimeMillis();
        CompletableFuture<List<HostPort>> proxiesFuture = this.proxyGetter.getProxies();
        proxiesFuture.whenCompleteAsync((result, error) -> {
            if (error == null) {
                logger.debug("Successfully discovered {} rpc proxies DataCenter: {}", (Object)result.size(), (Object)this.getDataCenterName());
                this.updateClients((Collection<HostPort>)result);
            } else {
                logger.warn("Failed to discover rpc proxies DataCenter: {} Error: ", (Object)this.getDataCenterName(), error);
                this.updateWithError((Throwable)error);
            }
            if (scheduleNextUpdate) {
                ClientPoolService clientPoolService = this;
                synchronized (clientPoolService) {
                    if (this.state == State.RUNNING) {
                        this.nextUpdate = this.executorService.schedule(() -> this.doUpdate(true), Math.max(this.updatePeriodMs - (System.currentTimeMillis() - startUpdateTime), 0L), TimeUnit.MILLISECONDS);
                    } else if (this.state != State.STOPPED) {
                        throw new IllegalArgumentException("ClientPoolService is in unexpected state: " + String.valueOf((Object)this.state));
                    }
                }
            }
        }, (Executor)this.executorService);
    }

    private static enum State {
        NOT_STARTED,
        RUNNING,
        STOPPED;

    }

    static class DiscoveryClientPoolBuilder {
        @Nullable
        RpcOptions options;
        @Nullable
        RpcClientFactory clientFactory;
        @Nullable
        EventLoopGroup eventLoop;
        @Nullable
        Random random;
        @Nullable
        Discoverer discoverer;

        DiscoveryClientPoolBuilder() {
        }

        DiscoveryClientPoolBuilder setOptions(RpcOptions options) {
            this.options = options;
            return this;
        }

        DiscoveryClientPoolBuilder setClientFactory(RpcClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return this;
        }

        DiscoveryClientPoolBuilder setEventLoop(EventLoopGroup eventLoop) {
            this.eventLoop = eventLoop;
            return this;
        }

        DiscoveryClientPoolBuilder setRandom(Random random) {
            this.random = random;
            return this;
        }

        DiscoveryClientPoolBuilder setDiscoverer(Discoverer discoverer) {
            this.discoverer = discoverer;
            return this;
        }

        ClientPoolService build() {
            return new ClientPoolService(this);
        }
    }

    static class RpcBuilder
    extends BaseBuilder<RpcBuilder> {
        @Nullable
        List<HostPort> initialProxyList;

        RpcBuilder() {
        }

        RpcBuilder setInitialProxyList(List<HostPort> initialProxyList) {
            this.initialProxyList = initialProxyList;
            return this;
        }

        ClientPoolService build() {
            return new ClientPoolService(this);
        }
    }

    static class HttpBuilder
    extends BaseBuilder<HttpBuilder> {
        private static final String IP_V6_REG_EX = "[0-9a-fA-F]{0,4}(:[0-9a-fA-F]{0,4}){2,7}";
        @Nullable
        String balancerFqdn;
        @Nullable
        Integer balancerPort;

        HttpBuilder() {
        }

        HttpBuilder setBalancerFqdn(String fqdn) {
            if (fqdn.matches(IP_V6_REG_EX)) {
                this.balancerFqdn = String.format("[%s]", fqdn);
            } else if (fqdn.matches("\\[[0-9a-fA-F]{0,4}(:[0-9a-fA-F]{0,4}){2,7}]") || !fqdn.contains(":")) {
                this.balancerFqdn = fqdn;
            } else {
                throw new IllegalArgumentException("Bad FQDN: " + fqdn);
            }
            return this;
        }

        HttpBuilder setBalancerPort(@Nullable Integer port) {
            if (port != null && (port < 0 || port > 65535)) {
                throw new IllegalArgumentException("Bad port: " + port);
            }
            this.balancerPort = port;
            return this;
        }

        ClientPoolService build() {
            return new ClientPoolService(this);
        }
    }

    static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        @Nullable
        String role;
        boolean useTLS = false;
        boolean tvmOnly = false;
        boolean ignoreBalancers = false;
        @Nullable
        String token;
        @Nullable
        String dataCenterName;
        @Nullable
        RpcOptions options;
        @Nullable
        RpcClientFactory clientFactory;
        @Nullable
        EventLoopGroup eventLoop;
        @Nullable
        Random random;
        @Nullable
        String proxyNetworkName;

        BaseBuilder() {
        }

        T setDataCenterName(String dataCenterName) {
            this.dataCenterName = dataCenterName;
            return (T)this;
        }

        T setOptions(RpcOptions options) {
            this.options = options;
            return (T)this;
        }

        T setClientFactory(RpcClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return (T)this;
        }

        T setEventLoop(EventLoopGroup eventLoop) {
            this.eventLoop = eventLoop;
            return (T)this;
        }

        T setRandom(Random random) {
            this.random = random;
            return (T)this;
        }

        T setRole(@Nullable String role) {
            this.role = role;
            return (T)this;
        }

        T setUseTLS(boolean useTLS) {
            this.useTLS = useTLS;
            return (T)this;
        }

        T setTvmOnly(boolean tvmOnly) {
            this.tvmOnly = tvmOnly;
            return (T)this;
        }

        T setIgnoreBalancers(boolean ignoreBalancers) {
            this.ignoreBalancers = ignoreBalancers;
            return (T)this;
        }

        T setToken(@Nullable String token) {
            this.token = token;
            return (T)this;
        }

        T setProxyNetworkName(@Nullable String proxyNetworkName) {
            this.proxyNetworkName = proxyNetworkName;
            return (T)this;
        }
    }
}

