/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.RetryPolicy;
import tech.ytsaurus.client.request.MountTable;
import tech.ytsaurus.client.request.UnmountTable;
import tech.ytsaurus.core.GUID;

public interface CompoundClient
extends ApiServiceClient,
Closeable {
    public <T> CompletableFuture<T> retryWithTabletTransaction(Function<ApiServiceTransaction, CompletableFuture<T>> var1, ExecutorService var2, RetryPolicy var3);

    public CompletableFuture<Void> mountTableAndWaitTablets(MountTable var1);

    default public CompletableFuture<Void> mountTableAndWaitTablets(MountTable.BuilderBase<?> req) {
        return this.mountTableAndWaitTablets(req.build());
    }

    public CompletableFuture<Void> mountTable(String var1, GUID var2, boolean var3, boolean var4, @Nullable Duration var5);

    default public CompletableFuture<Void> mountTable(String path, GUID cellId, boolean freeze, boolean waitMounted) {
        return this.mountTable(path, cellId, freeze, waitMounted, null);
    }

    default public CompletableFuture<Void> mountTable(String path, GUID cellId, boolean freeze) {
        return this.mountTable(path, cellId, freeze, null);
    }

    default public CompletableFuture<Void> mountTable(String path, GUID cellId, boolean freeze, @Nullable Duration requestTimeout) {
        return this.mountTable(path, cellId, freeze, false, requestTimeout);
    }

    default public CompletableFuture<Void> mountTable(String path) {
        return this.mountTable(path, null);
    }

    default public CompletableFuture<Void> mountTable(String path, @Nullable Duration requestTimeout) {
        return this.mountTable(path, null, false, requestTimeout);
    }

    default public CompletableFuture<Void> mountTable(String path, boolean freeze) {
        return this.mountTable(path, freeze, null);
    }

    default public CompletableFuture<Void> mountTable(String path, boolean freeze, @Nullable Duration requestTimeout) {
        return this.mountTable(path, null, freeze, requestTimeout);
    }

    public CompletableFuture<Void> unmountTableAndWaitTablets(UnmountTable var1);

    default public CompletableFuture<Void> unmountTableAndWaitTablets(UnmountTable.BuilderBase<?> req) {
        return this.unmountTableAndWaitTablets(req.build());
    }

    default public CompletableFuture<Void> unmountTableAndWaitTablets(String path) {
        return this.unmountTableAndWaitTablets(((UnmountTable.Builder)UnmountTable.builder().setPath(path)).build());
    }

    default public CompletableFuture<Void> unmountTable(String path) {
        return this.unmountTable(((UnmountTable.Builder)UnmountTable.builder().setPath(path)).build());
    }
}

