/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceClientImpl;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.AsyncRetryingTableWriterImpl;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.client.RetryPolicy;
import tech.ytsaurus.client.RetryingTableWriterImpl;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.TableWriter;
import tech.ytsaurus.client.TransactionRetrier;
import tech.ytsaurus.client.YTsaurusClientConfig;
import tech.ytsaurus.client.request.MountTable;
import tech.ytsaurus.client.request.TransactionType;
import tech.ytsaurus.client.request.UnmountTable;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.core.GUID;

public abstract class CompoundClientImpl
extends ApiServiceClientImpl
implements CompoundClient {
    private final ScheduledExecutorService executorService;

    public CompoundClientImpl(ScheduledExecutorService executorService, YTsaurusClientConfig configuration, Executor heavyExecutor, SerializationResolver serializationResolver) {
        super(null, configuration, heavyExecutor, executorService, serializationResolver);
        this.executorService = executorService;
    }

    public CompoundClientImpl(RpcClient client, ScheduledExecutorService executorService, YTsaurusClientConfig configuration, Executor heavyExecutor, SerializationResolver serializationResolver) {
        super(client, configuration, heavyExecutor, executorService, serializationResolver);
        this.executorService = executorService;
    }

    public CompoundClientImpl(ScheduledExecutorService executorService, RpcOptions rpcOptions, Executor heavyExecutor, SerializationResolver serializationResolver) {
        this(executorService, YTsaurusClientConfig.builder().withPorto().setRpcOptions(rpcOptions).build(), heavyExecutor, serializationResolver);
    }

    @Override
    public <T> CompletableFuture<T> retryWithTabletTransaction(Function<ApiServiceTransaction, CompletableFuture<T>> action, ExecutorService executor, RetryPolicy retryPolicy) {
        TransactionRetrier<T> transactionRetrier = new TransactionRetrier<T>(TransactionType.Tablet, this, this.executorService, action, executor, retryPolicy, this.rpcOptions);
        return transactionRetrier.run();
    }

    @Override
    public <T> CompletableFuture<TableWriter<T>> writeTable(WriteTable<T> req) {
        if (req.getNeedRetries()) {
            return CompletableFuture.completedFuture(new RetryingTableWriterImpl<T>(this, this.executorService, req, this.rpcOptions, this.serializationResolver)).thenCompose(writer -> writer.readyEvent().thenApply(unused -> writer));
        }
        return super.writeTable(req);
    }

    @Override
    public <T> CompletableFuture<AsyncWriter<T>> writeTableV2(WriteTable<T> req) {
        if (req.getNeedRetries()) {
            return CompletableFuture.completedFuture(new AsyncRetryingTableWriterImpl<T>(this, this.executorService, req, this.rpcOptions, this.serializationResolver));
        }
        return super.writeTableV2(req);
    }

    @Override
    public CompletableFuture<Void> mountTableAndWaitTablets(MountTable req) {
        return this.mountTable(req).thenCompose(res -> this.waitTabletState(req.getPath(), "mounted"));
    }

    @Override
    public CompletableFuture<Void> mountTable(String path, GUID cellId, boolean freeze, boolean waitMounted, @Nullable Duration requestTimeout) {
        MountTable.Builder builder = (MountTable.Builder)MountTable.builder().setPath(path);
        if (cellId != null) {
            builder.setCellId(cellId);
        }
        builder.setFreeze(freeze);
        if (requestTimeout != null) {
            builder.setTimeout(requestTimeout);
        }
        if (waitMounted) {
            return this.mountTableAndWaitTablets(builder.build());
        }
        return this.mountTable(builder.build());
    }

    @Override
    public CompletableFuture<Void> unmountTableAndWaitTablets(UnmountTable req) {
        String path = req.getPath();
        return this.unmountTable(req).thenCompose(rsp -> this.waitTabletState(path, "unmounted"));
    }

    private void runTabletsStateChecker(String tablePath, CompletableFuture<Void> futureToComplete, String state) {
        ((CompletableFuture)this.getNode(tablePath + "/@tablet_state").thenAccept(tabletState -> {
            if (tabletState.stringValue().equals(state)) {
                futureToComplete.complete(null);
            } else {
                this.executorService.schedule(() -> this.runTabletsStateChecker(tablePath, futureToComplete, state), 1L, TimeUnit.SECONDS);
            }
        })).exceptionally(e -> {
            futureToComplete.completeExceptionally((Throwable)e);
            return null;
        });
    }

    private CompletableFuture<Void> waitTabletState(String tablePath, String targetState) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.runTabletsStateChecker(tablePath, result, targetState);
        return result;
    }
}

