/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nullable;
import tech.ytsaurus.client.CompoundClientImpl;
import tech.ytsaurus.client.DefaultSerializationResolver;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.YTsaurusClientConfig;
import tech.ytsaurus.client.bus.BusConnector;
import tech.ytsaurus.client.bus.DefaultBusConnector;
import tech.ytsaurus.client.rpc.DefaultRpcBusClient;
import tech.ytsaurus.client.rpc.YTsaurusClientAuth;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class DirectYTsaurusClient
extends CompoundClientImpl {
    private final BusConnector busConnector;
    private final boolean isBusConnectorOwner;

    DirectYTsaurusClient(Builder builder) {
        super(new DefaultRpcBusClient(builder.busConnector, builder.address, builder.address.toString()).withAuthentication(builder.auth), builder.busConnector.executorService(), builder.config, builder.heavyExecutor, builder.serializationResolver);
        this.busConnector = builder.busConnector;
        this.isBusConnectorOwner = builder.isBusConnectorOwner;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
        if (this.isBusConnectorOwner) {
            this.busConnector.close();
        }
        super.close();
    }

    @NonNullApi
    @NonNullFields
    public static class Builder {
        @Nullable
        BusConnector busConnector;
        boolean isBusConnectorOwner = true;
        @Nullable
        SocketAddress address;
        @Nullable
        YTsaurusClientAuth auth;
        @Nullable
        YTsaurusClientConfig config;
        @Nullable
        Executor heavyExecutor;
        @Nullable
        SerializationResolver serializationResolver;

        Builder() {
        }

        public Builder setOwnBusConnector(BusConnector connector) {
            this.busConnector = connector;
            this.isBusConnectorOwner = true;
            return this.self();
        }

        public Builder setSharedBusConnector(BusConnector connector) {
            this.busConnector = connector;
            this.isBusConnectorOwner = false;
            return this.self();
        }

        public Builder setAddress(SocketAddress address) {
            this.address = address;
            return this.self();
        }

        public Builder setHeavyExecutor(Executor heavyExecutor) {
            this.heavyExecutor = heavyExecutor;
            return this.self();
        }

        public Builder setAuth(YTsaurusClientAuth auth) {
            this.auth = auth;
            return this.self();
        }

        public Builder setConfig(YTsaurusClientConfig config) {
            this.config = config;
            return this.self();
        }

        protected Builder self() {
            return this;
        }

        public DirectYTsaurusClient build() {
            if (this.busConnector == null) {
                this.busConnector = new DefaultBusConnector();
            }
            if (this.auth == null) {
                this.auth = YTsaurusClientAuth.loadUserAndTokenFromEnvironment();
            }
            if (this.config == null) {
                this.config = YTsaurusClientConfig.builder().build();
            }
            if (this.heavyExecutor == null) {
                this.heavyExecutor = ForkJoinPool.commonPool();
            }
            if (this.serializationResolver == null) {
                this.serializationResolver = DefaultSerializationResolver.getInstance();
            }
            return new DirectYTsaurusClient(this);
        }
    }
}

