/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.MessageLite;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.TRspGetGroupMeta;
import tech.ytsaurus.TRspListGroups;
import tech.ytsaurus.TRspListMembers;
import tech.ytsaurus.client.ClientPoolService;
import tech.ytsaurus.client.RpcClientFactory;
import tech.ytsaurus.client.bus.BusConnector;
import tech.ytsaurus.client.discovery.Discoverer;
import tech.ytsaurus.client.discovery.DiscoveryServiceMethodTable;
import tech.ytsaurus.client.discovery.GetGroupMeta;
import tech.ytsaurus.client.discovery.GroupMeta;
import tech.ytsaurus.client.discovery.Heartbeat;
import tech.ytsaurus.client.discovery.ListGroups;
import tech.ytsaurus.client.discovery.ListGroupsResult;
import tech.ytsaurus.client.discovery.ListMembers;
import tech.ytsaurus.client.discovery.ListMembersResult;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.rpc.DefaultRpcBusClient;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcUtil;

public class DiscoveryClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryClient.class);
    private final BusConnector busConnector;
    private final boolean isBusConnectorOwner;
    private final RpcOptions rpcOptions;
    private final ClientPoolService clientPoolService;

    private DiscoveryClient(Builder builder) {
        this.busConnector = Objects.requireNonNull(builder.busConnector);
        this.isBusConnectorOwner = builder.isBusConnectorOwner;
        this.rpcOptions = Objects.requireNonNullElseGet(builder.rpcOptions, RpcOptions::new);
        RpcClientFactory factory = (hostPort, name) -> new DefaultRpcBusClient(this.busConnector, hostPort.toInetSocketAddress(), name);
        this.clientPoolService = ClientPoolService.discoveryClientPoolBuilder().setDiscoverer(Objects.requireNonNull(builder.discoverer)).setOptions(this.rpcOptions).setClientFactory(factory).setEventLoop(this.busConnector.eventLoopGroup()).setRandom(new Random()).build();
        this.clientPoolService.start();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() throws IOException {
        if (this.isBusConnectorOwner) {
            this.busConnector.close();
        }
    }

    private <RequestMsgBuilder extends MessageLite.Builder, ResponseMsg extends MessageLite, RequestType extends HighLevelRequest<RequestMsgBuilder>> CompletableFuture<RpcClientResponse<ResponseMsg>> invoke(RequestType req, RpcClientRequestBuilder<RequestMsgBuilder, ResponseMsg> builder) {
        logger.debug("Starting request {}; {}", builder, (Object)req.getArgumentsLogString());
        req.writeHeaderTo(builder.header());
        req.writeTo(builder);
        return builder.invokeVia(this.busConnector.executorService(), this.clientPoolService);
    }

    public CompletableFuture<ListMembersResult> listMembers(ListMembers req) {
        return RpcUtil.apply(this.invoke(req, DiscoveryServiceMethodTable.LIST_MEMBERS.createRequestBuilder(this.rpcOptions)), response -> new ListMembersResult((TRspListMembers)response.body()));
    }

    public CompletableFuture<GroupMeta> getGroupMeta(GetGroupMeta req) {
        return RpcUtil.apply(this.invoke(req, DiscoveryServiceMethodTable.GET_GROUP_META.createRequestBuilder(this.rpcOptions)), response -> GroupMeta.fromProto(((TRspGetGroupMeta)response.body()).getMeta()));
    }

    public CompletableFuture<Void> heartbeat(Heartbeat req) {
        return RpcUtil.apply(this.invoke(req, DiscoveryServiceMethodTable.HEARTBEAT.createRequestBuilder(this.rpcOptions)), response -> null);
    }

    public CompletableFuture<ListGroupsResult> listGroups(ListGroups req) {
        return RpcUtil.apply(this.invoke(req, DiscoveryServiceMethodTable.LIST_GROUPS.createRequestBuilder(this.rpcOptions)), response -> new ListGroupsResult((TRspListGroups)response.body()));
    }

    public static class Builder {
        @Nullable
        private BusConnector busConnector;
        private boolean isBusConnectorOwner = true;
        @Nullable
        private Discoverer discoverer;
        @Nullable
        private RpcOptions rpcOptions;

        private Builder() {
        }

        public Builder setOwnBusConnector(BusConnector connector) {
            this.busConnector = connector;
            this.isBusConnectorOwner = true;
            return this.self();
        }

        public Builder setSharedBusConnector(BusConnector connector) {
            this.busConnector = connector;
            this.isBusConnectorOwner = false;
            return this.self();
        }

        public Builder setDiscoverer(Discoverer discoverer) {
            this.discoverer = discoverer;
            return this.self();
        }

        public Builder setRpcOptions(RpcOptions rpcOptions) {
            this.rpcOptions = rpcOptions;
            return this.self();
        }

        public DiscoveryClient build() {
            return new DiscoveryClient(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

