/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.net.InetSocketAddress;
import java.util.Objects;

public class HostPort {
    final String host;
    final int port;

    private HostPort(String host, int port) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static HostPort parse(String hostPortString) {
        String host;
        String portString = null;
        if (hostPortString.startsWith("[")) {
            String[] hostAndPort = HostPort.getHostAndPortFromBracketedHost(hostPortString);
            host = hostAndPort[0];
            portString = hostAndPort[1];
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
            }
        }
        int port = 9013;
        if (portString != null && !portString.isEmpty()) {
            HostPort.checkArgument(!portString.startsWith("+"), "Unparsable port number: %s", hostPortString);
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unparsable port number: " + hostPortString);
            }
            HostPort.checkArgument(HostPort.isValidPort(port), "Port number out of range: %s", hostPortString);
        }
        return new HostPort(host, port);
    }

    private static String[] getHostAndPortFromBracketedHost(String hostPortString) {
        HostPort.checkArgument(hostPortString.charAt(0) == '[', "Bracketed host-port string must start with a bracket: %s", hostPortString);
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        HostPort.checkArgument(colonIndex > -1 && closeBracketIndex > colonIndex, "Invalid bracketed host/port: %s", hostPortString);
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            return new String[]{host, ""};
        }
        HostPort.checkArgument(hostPortString.charAt(closeBracketIndex + 1) == ':', "Only a colon may follow a close bracket: %s", hostPortString);
        for (int i = closeBracketIndex + 2; i < hostPortString.length(); ++i) {
            HostPort.checkArgument(Character.isDigit(hostPortString.charAt(i)), "Port must be numeric: %s", hostPortString);
        }
        return new String[]{host, hostPortString.substring(closeBracketIndex + 2)};
    }

    private static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostPort hostPort = (HostPort)o;
        return this.host.equals(hostPort.getHost()) && this.port == hostPort.getPort();
    }

    public int hashCode() {
        return 31 * this.host.hashCode() + this.port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.host.length() + 8);
        if (this.host.indexOf(58) >= 0) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        builder.append(':').append(this.port);
        return builder.toString();
    }
}

