/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.BaseYTsaurusClient;
import tech.ytsaurus.client.MultiExecutorMonitoring;
import tech.ytsaurus.client.MultiExecutorRequestTask;
import tech.ytsaurus.client.MultiYTsaurusClient;
import tech.ytsaurus.client.PenaltyProvider;

class MultiExecutor
implements Closeable {
    private final List<ClientEntry> clients;
    private final Duration banPenalty;
    private final Duration banDuration;
    private final PenaltyProvider penaltyProvider;
    private final MultiExecutorMonitoring executorMonitoring;

    MultiExecutor(List<MultiYTsaurusClient.YTsaurusClientOptions> clientOptions, Duration banPenalty, Duration banDuration, PenaltyProvider penaltyProvider, MultiExecutorMonitoring executorMonitoring) {
        this.clients = clientOptions.stream().map(x$0 -> new ClientEntry((MultiYTsaurusClient.YTsaurusClientOptions)x$0)).collect(Collectors.toUnmodifiableList());
        this.banPenalty = banPenalty;
        this.banDuration = banDuration;
        this.penaltyProvider = penaltyProvider;
        this.executorMonitoring = executorMonitoring;
    }

    <R> CompletableFuture<R> execute(Function<BaseYTsaurusClient, CompletableFuture<R>> callback) {
        return new MultiExecutorRequestTask<R>(this.getEffectiveClientOptions(Instant.now()), callback, this.executorMonitoring).getFuture();
    }

    private synchronized List<MultiExecutorRequestTask.ClientEntry> getEffectiveClientOptions(Instant now) {
        for (ClientEntry client2 : this.clients) {
            if (client2.banUntil != null && client2.banUntil.compareTo(now) < 0) {
                client2.adaptivePenalty = Duration.ZERO;
            }
            client2.externalPenalty = this.penaltyProvider.getPenalty(client2.clientOptions.getShortClusterName());
        }
        Duration minPenalty = (Duration)Collections.min(this.clients.stream().map(ClientEntry::getPenalty).collect(Collectors.toUnmodifiableList()));
        return this.clients.stream().map(client -> new MultiExecutorRequestTask.ClientEntry(client.clientOptions, client.getPenalty().minus(minPenalty), client::onFinishRequest)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public void close() throws IOException {
        this.penaltyProvider.close();
    }

    class ClientEntry {
        private final MultiYTsaurusClient.YTsaurusClientOptions clientOptions;
        private Duration adaptivePenalty;
        private Duration externalPenalty;
        @Nullable
        private Instant banUntil;

        ClientEntry(MultiYTsaurusClient.YTsaurusClientOptions clientOptions) {
            this(clientOptions, Duration.ZERO, Duration.ZERO, null);
        }

        ClientEntry(MultiYTsaurusClient.YTsaurusClientOptions clientOptions, Duration adaptivePenalty, @Nullable Duration externalPenalty, Instant banUntil) {
            if (clientOptions.client.getClusters().size() != 1) {
                throw new IllegalArgumentException("Got YTsaurusClient with more than 1 cluster");
            }
            this.clientOptions = clientOptions;
            this.adaptivePenalty = adaptivePenalty;
            this.externalPenalty = externalPenalty;
            this.banUntil = banUntil;
        }

        Duration getPenalty() {
            return this.clientOptions.initialPenalty.plus(this.adaptivePenalty).plus(this.externalPenalty);
        }

        public synchronized void onFinishRequest(Boolean success) {
            if (success.booleanValue()) {
                if (this.adaptivePenalty.compareTo(Duration.ZERO) > 0) {
                    this.banUntil = null;
                    this.adaptivePenalty = Duration.ZERO;
                }
            } else {
                this.banUntil = Instant.now().plus(MultiExecutor.this.banDuration);
                this.adaptivePenalty = this.adaptivePenalty.plus(MultiExecutor.this.banPenalty);
            }
        }
    }
}

