/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import tech.ytsaurus.client.BaseYTsaurusClient;
import tech.ytsaurus.client.ImmutableTransactionalClient;
import tech.ytsaurus.client.MultiExecutor;
import tech.ytsaurus.client.MultiExecutorMonitoring;
import tech.ytsaurus.client.NoopMultiExecutorMonitoring;
import tech.ytsaurus.client.PenaltyProvider;
import tech.ytsaurus.client.SelectRowsResult;
import tech.ytsaurus.client.YTsaurusClient;
import tech.ytsaurus.client.request.AbstractLookupRowsRequest;
import tech.ytsaurus.client.request.MultiLookupRowsRequest;
import tech.ytsaurus.client.request.SelectRowsRequest;
import tech.ytsaurus.client.rows.ConsumerSource;
import tech.ytsaurus.client.rows.UnversionedRowset;
import tech.ytsaurus.client.rows.VersionedRowset;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullFields
@NonNullApi
public class MultiYTsaurusClient
implements ImmutableTransactionalClient,
Closeable {
    private final List<YTsaurusClientOptions> clients = new ArrayList<YTsaurusClientOptions>();
    private final MultiExecutor executor;

    private MultiYTsaurusClient(Builder builder) {
        if (builder.clientsOptions.isEmpty() && builder.clusters.isEmpty() && builder.clients.isEmpty() && builder.preferredClusters.isEmpty()) {
            throw new IllegalArgumentException("No clients and no clusters in MultiYTsaurusClient's constructor");
        }
        this.clients.addAll(builder.clientsOptions);
        builder.clients.stream().map(client -> YTsaurusClientOptions.builder(client).setInitialPenalty(builder.preferredAllowance).build()).forEach(this.clients::add);
        builder.preferredClusters.stream().map(cluster -> (YTsaurusClient)((YTsaurusClient.ClientBuilder)((YTsaurusClient.ClientBuilder)((YTsaurusClient.ClientBuilder)((YTsaurusClient.BaseBuilder)builder.clientBuilderSupplier.get().setClusters((String)cluster, new String[0])).setConfig(builder.config)).setRpcCompression(builder.compression)).setAuth(builder.auth)).build()).map(client -> YTsaurusClientOptions.builder(client).build()).forEach(this.clients::add);
        builder.clusters.stream().map(cluster -> (YTsaurusClient)((YTsaurusClient.ClientBuilder)((YTsaurusClient.ClientBuilder)((YTsaurusClient.ClientBuilder)((YTsaurusClient.BaseBuilder)builder.clientBuilderSupplier.get().setClusters((String)cluster, new String[0])).setConfig(builder.config)).setRpcCompression(builder.compression)).setAuth(builder.auth)).build()).map(client -> YTsaurusClientOptions.builder(client).setInitialPenalty(builder.preferredAllowance).build()).forEach(this.clients::add);
        List clusterNames = this.clients.stream().map(YTsaurusClientOptions::getClusterName).collect(Collectors.toUnmodifiableList());
        if (clusterNames.stream().distinct().count() != (long)clusterNames.size()) {
            String duplicatesHint = clusterNames.stream().filter(clusterName -> Collections.frequency(clusterNames, clusterName) > 1).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Duplicate clusters are not permitted: " + duplicatesHint);
        }
        this.executor = new MultiExecutor(this.clients, builder.banPenalty, builder.banDuration, builder.penaltyProvider, builder.executorMonitoring);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
        try {
            for (YTsaurusClientOptions entry : this.clients) {
                entry.client.close();
            }
            this.executor.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public CompletableFuture<UnversionedRowset> lookupRows(AbstractLookupRowsRequest<?, ?> request) {
        return this.executor.execute(client -> client.lookupRows(request));
    }

    @Override
    public <T> CompletableFuture<List<T>> lookupRows(AbstractLookupRowsRequest<?, ?> request, YTreeRowSerializer<T> serializer) {
        return this.executor.execute(client -> client.lookupRows(request, serializer));
    }

    @Override
    public CompletableFuture<List<UnversionedRowset>> multiLookupRows(MultiLookupRowsRequest request) {
        return this.executor.execute(client -> client.multiLookupRows(request));
    }

    @Override
    public <T> CompletableFuture<List<List<T>>> multiLookupRows(MultiLookupRowsRequest request, YTreeRowSerializer<T> serializer) {
        return this.executor.execute(client -> client.multiLookupRows(request, serializer));
    }

    @Override
    public CompletableFuture<VersionedRowset> versionedLookupRows(AbstractLookupRowsRequest<?, ?> request) {
        return this.executor.execute(client -> client.versionedLookupRows(request));
    }

    @Override
    public CompletableFuture<SelectRowsResult> selectRowsV2(SelectRowsRequest request) {
        return this.executor.execute(client -> client.selectRowsV2(request));
    }

    @Override
    public CompletableFuture<UnversionedRowset> selectRows(SelectRowsRequest request) {
        return this.executor.execute(client -> client.selectRows(request));
    }

    @Override
    public <T> CompletableFuture<List<T>> selectRows(SelectRowsRequest request, YTreeRowSerializer<T> serializer) {
        return this.executor.execute(client -> client.selectRows(request, serializer));
    }

    @Override
    public <T> CompletableFuture<Void> selectRows(SelectRowsRequest request, YTreeRowSerializer<T> serializer, ConsumerSource<T> consumer) {
        return this.executor.execute(client -> client.selectRows(request, serializer, consumer));
    }

    @NonNullApi
    @NonNullFields
    public static class Builder
    extends YTsaurusClient.BaseBuilder<MultiYTsaurusClient, Builder> {
        List<YTsaurusClientOptions> clientsOptions = new ArrayList<YTsaurusClientOptions>();
        List<YTsaurusClient> clients = new ArrayList<YTsaurusClient>();
        List<String> clusters = new ArrayList<String>();
        List<String> preferredClusters = new ArrayList<String>();
        Duration banPenalty = Duration.ofMillis(1L);
        Duration banDuration = Duration.ofMillis(50L);
        PenaltyProvider penaltyProvider = PenaltyProvider.dummyPenaltyProviderBuilder().build();
        MultiExecutorMonitoring executorMonitoring = new NoopMultiExecutorMonitoring();
        Duration preferredAllowance = Duration.ofMillis(100L);
        Supplier<YTsaurusClient.ClientBuilder<? extends YTsaurusClient, ?>> clientBuilderSupplier = YTsaurusClient::builder;

        Builder() {
        }

        @Override
        public MultiYTsaurusClient build() {
            return new MultiYTsaurusClient(this);
        }

        public Builder addClient(YTsaurusClientOptions clientOptions) {
            this.clientsOptions.add(clientOptions);
            return this;
        }

        public Builder addClients(YTsaurusClientOptions first, YTsaurusClientOptions ... rest) {
            this.addClient(first);
            for (YTsaurusClientOptions clientOptions : rest) {
                this.addClient(clientOptions);
            }
            return this;
        }

        public Builder addClient(YTsaurusClient client) {
            this.clients.add(client);
            return this;
        }

        public Builder addClients(YTsaurusClient first, YTsaurusClient ... rest) {
            this.addClient(first);
            for (YTsaurusClient client : rest) {
                this.addClient(client);
            }
            return this;
        }

        public Builder addCluster(String cluster) {
            this.clusters.add(cluster);
            return this;
        }

        public Builder addPreferredCluster(String cluster) {
            this.preferredClusters.add(cluster);
            return this;
        }

        public Builder setBanPenalty(Duration banPenalty) {
            this.banPenalty = banPenalty;
            return this;
        }

        public Builder setBanDuration(Duration banDuration) {
            this.banDuration = banDuration;
            return this;
        }

        public Builder setPreferredAllowance(Duration preferredAllowance) {
            this.preferredAllowance = preferredAllowance;
            return this;
        }

        public Builder setPenaltyProvider(PenaltyProvider penaltyProvider) {
            this.penaltyProvider = penaltyProvider;
            return this;
        }

        public Builder setExecutorMonitoring(MultiExecutorMonitoring executorMonitoring) {
            this.executorMonitoring = executorMonitoring;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static class YTsaurusClientOptions {
        final BaseYTsaurusClient client;
        final Duration initialPenalty;

        YTsaurusClientOptions(Builder builder) {
            this.client = builder.client;
            this.initialPenalty = builder.initialPenalty;
        }

        public String getClusterName() {
            return this.client.getClusters().get(0).getName();
        }

        public String getShortClusterName() {
            return this.getClusterName().split("\\.")[0];
        }

        public static Builder builder(BaseYTsaurusClient client) {
            return new Builder(client);
        }

        public static class Builder {
            final BaseYTsaurusClient client;
            Duration initialPenalty = Duration.ZERO;

            public Builder(BaseYTsaurusClient client) {
                this.client = client;
            }

            public Builder setInitialPenalty(Duration initialPenalty) {
                this.initialPenalty = initialPenalty;
                return this;
            }

            public YTsaurusClientOptions build() {
                return new YTsaurusClientOptions(this);
            }
        }
    }
}

