/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import tech.ytsaurus.client.FilteringRpcClientPool;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientPool;
import tech.ytsaurus.lang.NonNullApi;

@NonNullApi
class NonRepeatingClientPool
implements RpcClientPool {
    private final FilteringRpcClientPool underlying;
    private final ConcurrentSkipListSet<String> usedClients = new ConcurrentSkipListSet();

    NonRepeatingClientPool(FilteringRpcClientPool underlying) {
        this.underlying = underlying;
    }

    @Override
    public CompletableFuture<RpcClient> peekClient(CompletableFuture<?> releaseFuture) {
        return this.underlying.peekClient(releaseFuture, c -> !this.usedClients.contains(c.getAddressString())).whenComplete((c, e) -> {
            if (c != null) {
                this.usedClients.add(c.getAddressString());
            }
        });
    }
}

