/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import tech.ytsaurus.client.HostPort;
import tech.ytsaurus.client.RpcClientFactory;
import tech.ytsaurus.client.bus.BusConnector;
import tech.ytsaurus.client.rpc.DefaultRpcBusClient;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcCompression;
import tech.ytsaurus.client.rpc.YTsaurusClientAuth;

class RpcClientFactoryImpl
implements RpcClientFactory {
    private final BusConnector connector;
    private final YTsaurusClientAuth auth;
    private final RpcCompression compression;

    RpcClientFactoryImpl(BusConnector connector, YTsaurusClientAuth auth, RpcCompression compression) {
        this.connector = connector;
        this.auth = auth;
        this.compression = compression;
    }

    @Override
    public RpcClient create(HostPort hostPort, String name) {
        RpcClient rpcClient = new DefaultRpcBusClient(this.connector, hostPort.toInetSocketAddress(), name);
        if (!this.compression.isEmpty()) {
            rpcClient = rpcClient.withCompression(this.compression);
        }
        if (this.auth.getToken().isPresent() || this.auth.getServiceTicketAuth().isPresent() || this.auth.getUserTicketAuth().isPresent()) {
            rpcClient = rpcClient.withAuthentication(this.auth);
        }
        return rpcClient;
    }
}

