/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.DiscoveryServiceClient;
import tech.ytsaurus.client.HostPort;
import tech.ytsaurus.client.ProxyGetter;
import tech.ytsaurus.client.RpcClientFactory;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientPool;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullFields
@NonNullApi
class RpcProxyGetter
implements ProxyGetter {
    final List<HostPort> initialProxyList;
    @Nullable
    final RpcClientPool clientPool;
    @Nullable
    final String role;
    final String dataCenterName;
    final RpcClientFactory clientFactory;
    final RpcOptions options;
    final Random random;

    RpcProxyGetter(List<HostPort> initialProxyList, @Nullable RpcClientPool clientPool, @Nullable String role, String dataCenterName, RpcClientFactory clientFactory, RpcOptions options, Random random) {
        this.initialProxyList = Collections.unmodifiableList(initialProxyList);
        this.clientPool = clientPool;
        this.role = role;
        this.dataCenterName = dataCenterName;
        this.clientFactory = clientFactory;
        this.options = options;
        this.random = random;
    }

    @Override
    public CompletableFuture<List<HostPort>> getProxies() {
        CompletableFuture<RpcClient> clientFuture;
        CompletableFuture releaseClientFuture = new CompletableFuture();
        RpcClient rpcClient = null;
        if (this.clientPool != null && (clientFuture = this.clientPool.peekClient(releaseClientFuture)).isDone() && !clientFuture.isCompletedExceptionally()) {
            rpcClient = clientFuture.join();
        }
        if (rpcClient == null) {
            HostPort address = this.initialProxyList.get(this.random.nextInt(this.initialProxyList.size()));
            rpcClient = this.clientFactory.create(address, this.dataCenterName);
        }
        DiscoveryServiceClient client = new DiscoveryServiceClient(rpcClient, this.options);
        CompletableFuture<List<String>> requestResult = client.discoverProxies(this.role);
        CompletionStage resultFuture = requestResult.thenApply(result -> result.stream().map(HostPort::parse).collect(Collectors.toList()));
        ((CompletableFuture)resultFuture).whenComplete((result, error) -> releaseClientFuture.complete(null));
        return resultFuture;
    }
}

