/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.HashMap;
import java.util.function.Consumer;

class SlidingWindow<T> {
    private final int maxSize;
    private final HashMap<Integer, T> window;
    private final Consumer<T> callback;
    private int nextSequenceNumber = 0;

    SlidingWindow(int maxSize, Consumer<T> callback) {
        this.maxSize = maxSize;
        this.callback = callback;
        this.window = new HashMap();
    }

    public void add(int sequenceNumber, T value) {
        if (sequenceNumber < this.nextSequenceNumber) {
            throw new IllegalArgumentException("Packet sequence number " + sequenceNumber + " is too small, must be >= " + this.nextSequenceNumber);
        }
        if (this.window.containsKey(sequenceNumber)) {
            throw new IllegalArgumentException("Packet with sequence number " + sequenceNumber + " is already queued");
        }
        if (this.window.size() >= this.maxSize) {
            throw new IllegalStateException("Packet window overflow, max size is " + this.maxSize);
        }
        this.window.put(sequenceNumber, value);
        while (this.window.containsKey(this.nextSequenceNumber)) {
            this.callback.accept(this.window.get(this.nextSequenceNumber));
            this.window.remove(this.nextSequenceNumber);
            ++this.nextSequenceNumber;
        }
    }
}

