/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.Attachment;
import tech.ytsaurus.client.StreamReaderImpl;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;

class Stash {
    protected static final Logger logger = LoggerFactory.getLogger(StreamReaderImpl.class);
    private final CompletableFuture<Void> completedFuture = CompletableFuture.completedFuture(null);
    private CompletableFuture<Void> readyEvent = new CompletableFuture();
    private Throwable ex = null;
    private boolean eof = false;
    private long offset = 0L;
    private final LinkedList<AbstractMap.SimpleEntry<byte[], Long>> attachments = new LinkedList();

    Stash() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(Attachment attachment) throws Throwable {
        LinkedList<AbstractMap.SimpleEntry<byte[], Long>> linkedList = this.attachments;
        synchronized (linkedList) {
            if (this.ex != null) {
                throw this.ex;
            }
            boolean needWakeup = this.attachments.isEmpty() && !this.eof;
            this.offset += attachment.getCompressedSize();
            this.attachments.addLast(new AbstractMap.SimpleEntry<byte[], Long>(attachment.getDecompressedBytes(), this.offset));
            if (needWakeup) {
                this.readyEvent.complete(null);
                this.readyEvent = new CompletableFuture();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEof() {
        LinkedList<AbstractMap.SimpleEntry<byte[], Long>> linkedList = this.attachments;
        synchronized (linkedList) {
            return this.eof;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] pop(RpcClientStreamControl control) {
        LinkedList<AbstractMap.SimpleEntry<byte[], Long>> linkedList = this.attachments;
        synchronized (linkedList) {
            if (this.attachments.isEmpty()) {
                return null;
            }
            AbstractMap.SimpleEntry<byte[], Long> message = this.attachments.removeFirst();
            control.feedback(message.getValue());
            this.eof = message.getKey() == null;
            return message.getKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> readyEvent() {
        LinkedList<AbstractMap.SimpleEntry<byte[], Long>> linkedList = this.attachments;
        synchronized (linkedList) {
            if (this.attachments.isEmpty() && !this.eof) {
                return this.readyEvent;
            }
            return this.completedFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void error(Throwable ex) {
        LinkedList<AbstractMap.SimpleEntry<byte[], Long>> linkedList = this.attachments;
        synchronized (linkedList) {
            this.ex = ex;
            this.readyEvent.completeExceptionally(ex);
        }
    }
}

