/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.rpc.Codec;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.LazyResponse;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.rpc.TResponseHeader;

abstract class StreamBase<RspType extends Message>
implements RpcStreamConsumer {
    protected static final Logger logger = LoggerFactory.getLogger(StreamBase.class);
    protected final CompletableFuture<RpcClientResponse<RspType>> result = new CompletableFuture();
    private final CompletableFuture<RpcClientStreamControl> controlFuture = new CompletableFuture();
    protected volatile RpcClientStreamControl control;
    protected Compression compression;
    protected Codec codec = null;
    private int currentCodecId = -1;

    StreamBase() {
    }

    @Override
    public void onStartStream(RpcClientStreamControl control) {
        this.control = control;
        this.controlFuture.complete(control);
    }

    protected abstract Parser<RspType> responseParser();

    protected void maybeReinitCodec(int codecId) {
        if (this.currentCodecId != codecId) {
            this.compression = Compression.fromValue(codecId);
            this.codec = Codec.codecFor(this.compression);
            this.currentCodecId = codecId;
        }
    }

    List<byte[]> decompressedAttachments(int codecId, List<byte[]> attachments) {
        List<byte[]> decompressed;
        this.maybeReinitCodec(codecId);
        if (this.currentCodecId == 0) {
            decompressed = attachments;
        } else {
            decompressed = new ArrayList<byte[]>();
            for (byte[] attachment : attachments) {
                if (attachment == null) {
                    decompressed.add(null);
                    continue;
                }
                decompressed.add(this.codec.decompress(attachment));
            }
        }
        return decompressed;
    }

    @Override
    public void onResponse(RpcClient sender, TResponseHeader header, List<byte[]> attachments) {
        if (!this.result.isDone()) {
            if (attachments.size() < 1 || attachments.get(0) == null) {
                throw new IllegalStateException("Received response without a body");
            }
            attachments = this.decompressedAttachments(header.getCodec(), attachments);
            this.result.complete(new LazyResponse<RspType>(this.responseParser(), attachments.get(0), new ArrayList<byte[]>(attachments.subList(1, attachments.size())), sender, header));
        }
    }

    @Override
    public void onError(Throwable error) {
        logger.error("Error", error);
        this.result.completeExceptionally(error);
    }

    @Override
    public void onCancel(CancellationException cancel) {
        this.result.completeExceptionally(cancel);
    }

    public void cancel() {
        this.controlFuture.thenApply(RpcClientRequestControl::cancel);
    }

    @Nullable
    String getRpcProxyAddress() {
        return this.control.getRpcProxyAddress();
    }
}

