/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import tech.ytsaurus.client.Attachment;
import tech.ytsaurus.client.Payload;
import tech.ytsaurus.client.SlidingWindow;
import tech.ytsaurus.client.Stash;
import tech.ytsaurus.client.StreamBase;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.rpc.TStreamingFeedbackHeader;
import tech.ytsaurus.rpc.TStreamingPayloadHeader;

abstract class StreamReaderImpl<RspType extends Message>
extends StreamBase<RspType> {
    private static final int MAX_WINDOW_SIZE = 16384;
    private final Stash stash = new Stash();
    private final SlidingWindow<Payload> window = new SlidingWindow<Payload>(16384, payload -> {
        for (Attachment attachment : payload.getAttachments()) {
            try {
                this.stash.push(attachment);
            }
            catch (Throwable ex) {
                this.onError(ex);
            }
        }
    });

    StreamReaderImpl() {
        this.result.whenComplete((unused, ex) -> {
            if (ex != null) {
                this.stash.error((Throwable)ex);
            }
        });
    }

    @Override
    public void onStartStream(RpcClientStreamControl control) {
        super.onStartStream(control);
        control.sendEof();
    }

    @Override
    public void onFeedback(RpcClient sender, TStreamingFeedbackHeader header, List<byte[]> attachments) {
    }

    @Override
    public void onPayload(RpcClient sender, TStreamingPayloadHeader header, List<byte[]> attachments) {
        if (attachments.isEmpty()) {
            throw new IllegalArgumentException("Empty attachments");
        }
        int sequenceNumber = header.getSequenceNumber();
        this.maybeReinitCodec(header.getCodec());
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>(attachments.size());
        for (byte[] attachment : attachments) {
            long size = attachment == null ? 1L : (long)attachment.length;
            byte[] attachmentDecompressed = attachment != null ? this.codec.decompress(attachment) : null;
            attachmentList.add(new Attachment(size, attachmentDecompressed));
        }
        this.window.add(sequenceNumber, new Payload(attachmentList, sender));
    }

    CompletableFuture<byte[]> readHead() {
        return this.getReadyEvent().thenApply(unused -> this.stash.pop(this.control));
    }

    boolean doCanRead() {
        return !this.stash.isEof();
    }

    byte[] doRead() throws Exception {
        if (this.result.isCompletedExceptionally()) {
            this.result.get();
            return null;
        }
        return this.stash.pop(this.control);
    }

    CompletableFuture<Void> getReadyEvent() {
        return CompletableFuture.anyOf(this.stash.readyEvent(), this.result).thenAccept(unused -> {});
    }

    CompletableFuture<Void> doClose() {
        this.control.cancel();
        return this.result.handle((unused, error) -> null);
    }

    @Override
    public void onWakeup() {
    }
}

