/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import tech.ytsaurus.client.DataSupplier;
import tech.ytsaurus.client.MessagesSupplier;
import tech.ytsaurus.client.StreamBase;
import tech.ytsaurus.client.StreamWriter;
import tech.ytsaurus.client.WrappedSupplier;
import tech.ytsaurus.client.rpc.Codec;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.rpc.TStreamingFeedbackHeader;
import tech.ytsaurus.rpc.TStreamingPayloadHeader;

abstract class StreamWriterImpl<T extends Message>
extends StreamBase<T>
implements RpcStreamConsumer,
StreamWriter {
    private static final CompletableFuture<Void> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    protected final CompletableFuture<List<byte[]>> startUpload = new CompletableFuture();
    private final Object lock = new Object();
    private volatile DataSupplier supplier;
    private CompletableFuture<Void> readyEvent = new CompletableFuture();
    private long writePosition = 0L;
    private long readPosition = 0L;
    private final long windowSize;
    private final long packetSize;
    private final List<byte[]> payloadAttachments = new LinkedList<byte[]>();
    private long payloadOffset = 0L;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    protected StreamWriterImpl(long windowSize, long packetSize) {
        this.windowSize = windowSize;
        this.packetSize = packetSize;
        this.result.whenComplete((unused, ex) -> {
            if (ex != null) {
                this.startUpload.completeExceptionally((Throwable)ex);
            }
        });
    }

    @Override
    public void onStartStream(RpcClientStreamControl control) {
        this.supplier = new WrappedSupplier(new MessagesSupplier(), Codec.codecFor(control.getExpectedPayloadCompression()));
        super.onStartStream(control);
    }

    private void reinitReadyEvent() {
        this.readyEvent.complete(null);
        this.readyEvent = new CompletableFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadSome() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.supplier.hasData()) {
                return;
            }
        }
        LinkedList<byte[]> readyToUpload = new LinkedList<byte[]>();
        Object object2 = this.lock;
        synchronized (object2) {
            byte[] next;
            for (long sendSize = 0L; this.supplier.hasData() && sendSize < this.windowSize; sendSize += (long)RpcUtil.attachmentSize(next)) {
                next = this.supplier.get();
                readyToUpload.add(next);
            }
        }
        while (!readyToUpload.isEmpty()) {
            byte[] data;
            ArrayList<byte[]> packet = new ArrayList<byte[]>();
            for (long currentPacketSize = 0L; !readyToUpload.isEmpty() && currentPacketSize < this.packetSize; currentPacketSize += (long)RpcUtil.attachmentSize(data)) {
                data = (byte[])readyToUpload.peekFirst();
                packet.add(data);
                readyToUpload.removeFirst();
            }
            if (logger.isTraceEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[");
                for (byte[] data2 : packet) {
                    stringBuilder.append(RpcUtil.attachmentSize(data2));
                    stringBuilder.append(", ");
                }
                stringBuilder.append("]");
                logger.trace("Packet: {} {}", (Object)stringBuilder.toString(), (Object)(this.writePosition - this.readPosition));
            }
            this.control.sendPayload(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFeedback(RpcClient sender, TStreamingFeedbackHeader header, List<byte[]> attachments) {
        if (!attachments.isEmpty()) {
            throw new IllegalArgumentException("protocol error in onFeedback");
        }
        Object object = this.lock;
        synchronized (object) {
            this.readPosition = header.getReadPosition();
            if (this.writePosition - this.readPosition < this.windowSize) {
                this.reinitReadyEvent();
            }
        }
        this.uploadSome();
    }

    @Override
    public void onPayload(RpcClient sender, TStreamingPayloadHeader header, List<byte[]> attachments) {
        boolean eof = false;
        this.maybeReinitCodec(header.getCodec());
        for (byte[] attachment : attachments) {
            this.payloadOffset += (long)RpcUtil.attachmentSize(attachment);
            if (attachment != null) {
                this.payloadAttachments.add(this.codec.decompress(attachment));
                continue;
            }
            eof = true;
        }
        if (eof) {
            if (!this.startUpload.isDone()) {
                this.startUpload.complete(this.payloadAttachments);
            } else {
                throw new IllegalArgumentException("protocol error in onPayload");
            }
        }
        this.control.feedback(this.payloadOffset);
    }

    @Override
    public void onWakeup() {
        this.uploadSome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean push(byte[] data) {
        if (this.result.isCompletedExceptionally()) {
            this.result.join();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.writePosition - this.readPosition >= this.windowSize) {
                return false;
            }
            this.writePosition += (long)this.supplier.put(data);
            if (this.writePosition - this.readPosition < this.windowSize) {
                this.reinitReadyEvent();
            }
        }
        this.control.wakeUp();
        if (this.closed.get() && data != null) {
            throw new IllegalStateException("StreamWriter is already closed");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable error) {
        super.onError(error);
        Object object = this.lock;
        synchronized (object) {
            this.reinitReadyEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancel(CancellationException cancel) {
        super.onCancel(cancel);
        Object object = this.lock;
        synchronized (object) {
            this.reinitReadyEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> readyEvent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writePosition - this.readPosition < this.windowSize) {
                return COMPLETED_FUTURE;
            }
            return this.readyEvent;
        }
    }

    @Override
    public CompletableFuture<?> close() {
        this.closed.set(true);
        return ((CompletableFuture)this.readyEvent().thenAccept(unused -> this.push(null))).thenCompose(unused -> this.result);
    }
}

