/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import tech.ytsaurus.client.TableAttachmentRowsetReader;
import tech.ytsaurus.client.rows.WireProtocolReader;
import tech.ytsaurus.client.rows.WireRowDeserializer;

class TableAttachmentWireProtocolReader<T>
extends TableAttachmentRowsetReader<T> {
    private final WireRowDeserializer<T> deserializer;

    TableAttachmentWireProtocolReader(WireRowDeserializer<T> deserializer) {
        this.deserializer = Objects.requireNonNull(deserializer);
    }

    @Override
    protected List<T> parseMergedRow(ByteBuffer bb, int size) {
        byte[] data = new byte[size];
        bb.get(data);
        WireProtocolReader reader = new WireProtocolReader(Arrays.asList(new byte[][]{data}));
        Objects.requireNonNull(this.currentReadSchema);
        this.deserializer.updateSchema(this.currentReadSchema);
        int rowCount = reader.readRowCount();
        ArrayList<T> rows = new ArrayList<T>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rows.add(reader.readUnversionedRow(this.deserializer));
        }
        return rows;
    }
}

