/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.Parser;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.StreamReaderImpl;
import tech.ytsaurus.client.TableAttachmentReader;
import tech.ytsaurus.client.TableAttachmentWireProtocolReader;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.rpcproxy.TRspReadTable;
import tech.ytsaurus.rpcproxy.TRspReadTableMeta;

class TableReaderBaseImpl<T>
extends StreamReaderImpl<TRspReadTable> {
    private static final Parser<TRspReadTableMeta> META_PARSER = TRspReadTableMeta.parser();
    @Nullable
    protected TableAttachmentReader<T> reader;
    @Nullable
    private final Class<T> objectClazz;
    protected TRspReadTableMeta metadata = null;
    @Nullable
    protected ApiServiceTransaction transaction;

    TableReaderBaseImpl(Class<T> objectClazz) {
        this.objectClazz = objectClazz;
    }

    TableReaderBaseImpl(TableAttachmentReader<T> reader) {
        this.reader = reader;
        this.objectClazz = null;
    }

    public void setTransaction(ApiServiceTransaction transaction) {
        if (this.transaction != null) {
            throw new IllegalStateException("Read transaction already started");
        }
        this.transaction = transaction;
    }

    @Override
    protected Parser<TRspReadTable> responseParser() {
        return TRspReadTable.parser();
    }

    public CompletableFuture<TableReaderBaseImpl<T>> waitMetadataImpl(SerializationResolver serializationResolver) {
        TableReaderBaseImpl self = this;
        return this.readHead().thenApply(data -> {
            self.metadata = RpcUtil.parseMessageBodyWithCompression(data, META_PARSER, Compression.None);
            if (self.reader == null) {
                Objects.requireNonNull(self.objectClazz);
                YTreeRowSerializer serializer = serializationResolver.forClass(self.objectClazz, ApiServiceUtil.deserializeTableSchema(self.metadata.getSchema()));
                self.reader = new TableAttachmentWireProtocolReader(serializationResolver.createWireRowDeserializer(serializer));
            }
            return self;
        });
    }

    public boolean canRead() {
        return this.doCanRead();
    }

    public List<T> read() throws Exception {
        return this.reader.parse(this.doRead());
    }

    public CompletableFuture<Void> readyEvent() {
        return this.getReadyEvent();
    }
}

