/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.io.SequenceInputStream;
import tech.ytsaurus.client.TableRowsSerializer;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpcproxy.ERowsetFormat;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;

@NonNullApi
@NonNullFields
abstract class TableRowsSerializerBase<T>
implements TableRowsSerializer<T> {
    protected TRowsetDescriptor rowsetDescriptor;
    protected ByteBuf serializedRows;

    TableRowsSerializerBase(ERowsetFormat rowsetFormat) {
        this.rowsetDescriptor = TRowsetDescriptor.newBuilder().setRowsetFormat(rowsetFormat).build();
        this.serializedRows = Unpooled.buffer();
    }

    @Override
    public TRowsetDescriptor getRowsetDescriptor() {
        return this.rowsetDescriptor;
    }

    @Override
    public InputStream flush() {
        if (this.serializedRows.readableBytes() == 0) {
            return InputStream.nullInputStream();
        }
        ByteBuf metaBuf = Unpooled.buffer();
        this.writeMeta(metaBuf);
        ByteBuf currentSerializedRows = this.serializedRows;
        this.serializedRows = Unpooled.buffer();
        return new SequenceInputStream((InputStream)new ByteBufInputStream(metaBuf), (InputStream)new ByteBufInputStream(currentSerializedRows));
    }

    @Override
    public int size() {
        if (this.serializedRows.readableBytes() == 0) {
            return 0;
        }
        return this.serializedRows.readableBytes() + this.getMetaSize();
    }

    protected abstract void writeMeta(ByteBuf var1);

    protected abstract int getMetaSize();
}

