/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import io.netty.buffer.ByteBuf;
import java.util.List;
import tech.ytsaurus.client.TableRowsSerializerBase;
import tech.ytsaurus.client.rows.EntitySkiffSerializer;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpcproxy.ERowsetFormat;

@NonNullApi
@NonNullFields
class TableRowsSkiffSerializer<T>
extends TableRowsSerializerBase<T> {
    private final EntitySkiffSerializer<T> serializer;

    TableRowsSkiffSerializer(EntitySkiffSerializer<T> serializer) {
        super(ERowsetFormat.RF_FORMAT);
        this.serializer = serializer;
    }

    @Override
    public void write(List<T> rows) {
        rows.forEach(row -> {
            this.serializedRows.writeByte(0);
            this.serializedRows.writeByte(0);
            this.serializedRows.writeBytes(this.serializer.serialize(row));
        });
    }

    @Override
    protected void writeMeta(ByteBuf buf) {
        buf.writeLongLE((long)this.serializedRows.readableBytes());
    }

    @Override
    protected int getMetaSize() {
        return 8;
    }
}

