/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import tech.ytsaurus.client.TableRowsSerializerBase;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.client.rows.WireProtocolWriter;
import tech.ytsaurus.client.rows.WireRowSerializer;
import tech.ytsaurus.core.tables.ColumnSchema;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpcproxy.ERowsetFormat;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;

@NonNullApi
@NonNullFields
class TableRowsWireSerializer<T>
extends TableRowsSerializerBase<T> {
    private final WireRowSerializer<T> wireRowSerializer;
    private final Map<String, Integer> columnToId = new HashMap<String, Integer>();
    private final ERowsetFormat rowsetFormat = ERowsetFormat.RF_YT_WIRE;
    private int rowsCount;

    TableRowsWireSerializer(WireRowSerializer<T> wireRowSerializer) {
        super(ERowsetFormat.RF_YT_WIRE);
        this.wireRowSerializer = Objects.requireNonNull(wireRowSerializer);
    }

    public TableSchema getSchema() {
        return this.wireRowSerializer.getSchema();
    }

    @Override
    public void write(List<T> rows) {
        throw new RuntimeException(new NoSuchMethodException());
    }

    @Override
    public InputStream flush() {
        InputStream in = super.flush();
        this.rowsCount = 0;
        return in;
    }

    void write(List<T> rows, TableSchema schema) {
        this.write(rows, schema, this.getCurrentRowsetDescriptor(schema));
    }

    void write(List<T> rows, TableSchema schema, TRowsetDescriptor currentDescriptor) {
        int[] idMapping = this.getIdMapping(rows, schema);
        WireProtocolWriter writer = new WireProtocolWriter();
        this.wireRowSerializer.updateSchema(currentDescriptor);
        writer.writeUnversionedRowsetWithoutCount(rows, this.wireRowSerializer, idMapping);
        for (byte[] bytes : writer.finish()) {
            this.serializedRows.writeBytes(bytes);
        }
        this.updateRowsetDescriptor(currentDescriptor);
        this.rowsCount += rows.size();
    }

    @Override
    protected void writeMeta(ByteBuf buf) {
        int mergedRowSizeIndex = buf.writerIndex();
        buf.writeLongLE(0L);
        WireProtocolWriter writer = new WireProtocolWriter();
        writer.writeRowCount(this.rowsCount);
        for (byte[] bytes : writer.finish()) {
            buf.writeBytes(bytes);
        }
        buf.setLongLE(mergedRowSizeIndex, (long)(this.serializedRows.readableBytes() + (buf.writerIndex() - mergedRowSizeIndex) - 8));
    }

    @Override
    protected int getMetaSize() {
        int rowsCountSize = 0;
        WireProtocolWriter writer = new WireProtocolWriter();
        writer.writeRowCount(this.rowsCount);
        for (byte[] bytes : writer.finish()) {
            rowsCountSize += bytes.length;
        }
        return 8 + rowsCountSize;
    }

    TRowsetDescriptor getCurrentRowsetDescriptor(TableSchema schema) {
        TRowsetDescriptor.Builder builder = TRowsetDescriptor.newBuilder();
        for (ColumnSchema descriptor : schema.getColumns()) {
            if (this.columnToId.containsKey(descriptor.getName())) continue;
            builder.addNameTableEntries(TRowsetDescriptor.TNameTableEntry.newBuilder().setName(descriptor.getName()).setType(descriptor.getWireType().getValue()).build());
            this.columnToId.put(descriptor.getName(), this.columnToId.size());
        }
        builder.setRowsetFormat(this.rowsetFormat);
        return builder.build();
    }

    private int[] getIdMapping(List<T> rows, TableSchema schema) {
        int[] idMapping;
        Iterator<T> it = rows.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException();
        }
        T first = it.next();
        boolean isUnversionedRows = first instanceof List && ((List)first).get(0) instanceof UnversionedRow;
        int[] nArray = idMapping = isUnversionedRows ? new int[this.columnToId.size()] : null;
        if (isUnversionedRows) {
            for (UnversionedRow row : rows) {
                List<UnversionedValue> values = row.getValues();
                for (int columnNumber = 0; columnNumber < schema.getColumns().size() && columnNumber < values.size(); ++columnNumber) {
                    int columnId;
                    String columnName = schema.getColumnName(columnNumber);
                    UnversionedValue value = values.get(columnNumber);
                    idMapping[value.getId()] = columnId = this.columnToId.get(columnName).intValue();
                }
            }
        }
        return idMapping;
    }

    private void updateRowsetDescriptor(TRowsetDescriptor currentDescriptor) {
        if (currentDescriptor.getNameTableEntriesCount() <= 0) {
            return;
        }
        TRowsetDescriptor.Builder merged = TRowsetDescriptor.newBuilder();
        merged.setRowsetFormat(this.rowsetFormat);
        merged.mergeFrom(this.rowsetDescriptor);
        merged.addAllNameTableEntries((Iterable)currentDescriptor.getNameTableEntriesList());
        this.rowsetDescriptor = merged.build();
    }
}

