/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import tech.ytsaurus.client.TableRowsSerializerBase;
import tech.ytsaurus.core.operations.YTreeBinarySerializer;
import tech.ytsaurus.core.rows.YTreeSerializer;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpcproxy.ERowsetFormat;

@NonNullApi
@NonNullFields
class TableRowsYsonSerializer<T>
extends TableRowsSerializerBase<T> {
    private final YTreeSerializer<T> ysonSerializer;

    TableRowsYsonSerializer(YTreeSerializer<T> ysonSerializer) {
        super(ERowsetFormat.RF_FORMAT);
        this.ysonSerializer = ysonSerializer;
    }

    @Override
    public void write(List<T> rows) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        YTreeBinarySerializer.serializeAllObjects(rows, this.ysonSerializer, (OutputStream)output);
        this.serializedRows.writeBytes(output.toByteArray());
    }

    @Override
    protected void writeMeta(ByteBuf buf) {
        buf.writeLongLE((long)this.serializedRows.readableBytes());
    }

    @Override
    protected int getMetaSize() {
        return 8;
    }
}

