/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.RawTableWriterImpl;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.TableRowsSerializer;
import tech.ytsaurus.client.TableRowsSerializerUtil;
import tech.ytsaurus.client.TableRowsWireSerializer;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowSerializer;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;
import tech.ytsaurus.rpcproxy.TWriteTableMeta;

@NonNullApi
class TableWriterBaseImpl<T>
extends RawTableWriterImpl {
    @Nullable
    protected TableSchema schema;
    protected final WriteTable<T> req;
    @Nullable
    protected TableRowsSerializer<T> tableRowsSerializer;
    private final SerializationResolver serializationResolver;
    @Nullable
    protected ApiServiceTransaction transaction;

    TableWriterBaseImpl(WriteTable<T> req, SerializationResolver serializationResolver) {
        super(req.getWindowSize(), req.getPacketSize());
        this.req = req;
        this.serializationResolver = serializationResolver;
        this.tableRowsSerializer = TableRowsSerializerUtil.createTableRowsSerializer(this.req.getSerializationContext(), serializationResolver).orElse(null);
    }

    public void setTransaction(ApiServiceTransaction transaction) {
        if (this.transaction != null) {
            throw new IllegalStateException("Write transaction already started");
        }
        this.transaction = transaction;
    }

    public CompletableFuture<TableWriterBaseImpl<T>> startUploadImpl() {
        TableWriterBaseImpl self = this;
        return this.startUpload.thenApply(attachments -> {
            if (attachments.size() != 1) {
                throw new IllegalArgumentException("protocol error");
            }
            byte[] head = (byte[])attachments.get(0);
            if (head == null) {
                throw new IllegalArgumentException("protocol error");
            }
            TWriteTableMeta metadata = (TWriteTableMeta)RpcUtil.parseMessageBodyWithCompression(head, TWriteTableMeta.parser(), Compression.None);
            self.schema = ApiServiceUtil.deserializeTableSchema(metadata.getSchema());
            logger.debug("schema -> {}", (Object)this.schema.toYTree().toString());
            if (this.tableRowsSerializer == null) {
                if (this.req.getSerializationContext().getObjectClass().isEmpty()) {
                    throw new IllegalStateException("No object clazz");
                }
                Class<T> objectClazz = self.req.getSerializationContext().getObjectClass().get();
                this.tableRowsSerializer = UnversionedRow.class.equals(objectClazz) ? new TableRowsWireSerializer<UnversionedRow>(new UnversionedRowSerializer()) : new TableRowsWireSerializer<T>(this.serializationResolver.createWireRowSerializer(this.serializationResolver.forClass(objectClazz, self.schema)));
            }
            return self;
        });
    }

    public boolean write(List<T> rows, TableSchema schema) throws IOException {
        byte[] serializedRows;
        if (this.tableRowsSerializer instanceof TableRowsWireSerializer) {
            TableRowsWireSerializer tableRowsWireSerializer = (TableRowsWireSerializer)this.tableRowsSerializer;
            TRowsetDescriptor descriptorDelta = tableRowsWireSerializer.getCurrentRowsetDescriptor(schema);
            tableRowsWireSerializer.write(rows, schema, descriptorDelta);
            serializedRows = TableRowsSerializerUtil.serializeRowsWithDescriptor(this.tableRowsSerializer, descriptorDelta);
        } else {
            this.tableRowsSerializer.write(rows);
            serializedRows = TableRowsSerializerUtil.serializeRowsWithDescriptor(this.tableRowsSerializer, this.tableRowsSerializer.getRowsetDescriptor());
        }
        return this.write(serializedRows);
    }

    @Override
    public CompletableFuture<?> close() {
        return super.close().thenCompose(response -> {
            if (this.transaction != null && this.transaction.isActive()) {
                return this.transaction.commit().thenApply(unused -> response);
            }
            return CompletableFuture.completedFuture(response);
        });
    }
}

