/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.RetryPolicy;
import tech.ytsaurus.client.misc.ScheduledSerializedExecutorService;
import tech.ytsaurus.client.request.StartTransaction;
import tech.ytsaurus.client.request.TransactionType;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullFields
@NonNullApi
class TransactionRetrier<T> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionRetrier.class);
    private final ApiServiceClient client;
    private final TransactionType transactionType;
    private final ScheduledExecutorService safeExecutor;
    private final ExecutorService userExecutor;
    private final Function<ApiServiceTransaction, CompletableFuture<T>> action;
    private final RetryPolicy retryPolicy;
    private final RpcOptions rpcOptions;
    private final CompletableFuture<T> result = new CompletableFuture();
    private Future<?> nextAttempt = new CompletableFuture();
    private int attemptIndex = 0;

    TransactionRetrier(TransactionType transactionType, ApiServiceClient client, ScheduledExecutorService executor, Function<ApiServiceTransaction, CompletableFuture<T>> action, ExecutorService userExecutor, RetryPolicy retryPolicy, RpcOptions rpcOptions) {
        this.transactionType = transactionType;
        this.client = client;
        this.safeExecutor = new ScheduledSerializedExecutorService(executor);
        this.action = action;
        this.userExecutor = userExecutor;
        this.retryPolicy = retryPolicy;
        this.rpcOptions = rpcOptions;
    }

    CompletableFuture<T> run() {
        this.nextAttempt = this.safeExecutor.submit(this::runAttemptUnsafe);
        this.result.whenCompleteAsync((res, error) -> this.nextAttempt.cancel(false), (Executor)this.safeExecutor);
        return this.result;
    }

    void runAttemptUnsafe() {
        if (this.result.isDone()) {
            return;
        }
        this.retryPolicy.onNewAttempt();
        ++this.attemptIndex;
        logger.debug("Starting attempt {} of {}", (Object)this.attemptIndex, (Object)this.retryPolicy.getTotalRetryCountDescription());
        ((CompletableFuture)this.client.startTransaction(new StartTransaction(this.transactionType)).thenComposeAsync(tx -> ((CompletableFuture)this.action.apply((ApiServiceTransaction)tx).thenCompose(res -> {
            if (tx.isActive()) {
                return tx.commit().thenApply(r -> res);
            }
            tx.close();
            return tx.getTransactionCompleteFuture().handle((r, e) -> res);
        })).whenComplete((res, err) -> {
            if (err != null) {
                tx.close();
            }
        }), (Executor)this.userExecutor)).whenCompleteAsync((res, error) -> {
            if (error == null) {
                this.result.complete(res);
                return;
            }
            Optional<Duration> backoff = this.retryPolicy.getBackoffDuration((Throwable)error, this.rpcOptions);
            if (backoff.isPresent()) {
                this.safeExecutor.schedule(this::runAttemptUnsafe, backoff.get().toNanos(), TimeUnit.NANOSECONDS);
            } else {
                this.result.completeExceptionally((Throwable)error);
            }
        }, (Executor)this.safeExecutor);
    }
}

