/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.AsyncReader;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.FileReader;
import tech.ytsaurus.client.FileWriter;
import tech.ytsaurus.client.ImmutableTransactionalClient;
import tech.ytsaurus.client.TableAttachmentReader;
import tech.ytsaurus.client.TableReader;
import tech.ytsaurus.client.TableWriter;
import tech.ytsaurus.client.operations.Operation;
import tech.ytsaurus.client.request.AdvanceConsumer;
import tech.ytsaurus.client.request.CheckPermission;
import tech.ytsaurus.client.request.ConcatenateNodes;
import tech.ytsaurus.client.request.CopyNode;
import tech.ytsaurus.client.request.CreateNode;
import tech.ytsaurus.client.request.ExistsNode;
import tech.ytsaurus.client.request.GetFileFromCache;
import tech.ytsaurus.client.request.GetFileFromCacheResult;
import tech.ytsaurus.client.request.GetNode;
import tech.ytsaurus.client.request.LinkNode;
import tech.ytsaurus.client.request.ListNode;
import tech.ytsaurus.client.request.LockNode;
import tech.ytsaurus.client.request.LockNodeResult;
import tech.ytsaurus.client.request.MapOperation;
import tech.ytsaurus.client.request.MapReduceOperation;
import tech.ytsaurus.client.request.MergeOperation;
import tech.ytsaurus.client.request.MoveNode;
import tech.ytsaurus.client.request.MultiTablePartition;
import tech.ytsaurus.client.request.PartitionTables;
import tech.ytsaurus.client.request.PutFileToCache;
import tech.ytsaurus.client.request.PutFileToCacheResult;
import tech.ytsaurus.client.request.ReadFile;
import tech.ytsaurus.client.request.ReadSerializationContext;
import tech.ytsaurus.client.request.ReadTable;
import tech.ytsaurus.client.request.ReadTableDirect;
import tech.ytsaurus.client.request.ReduceOperation;
import tech.ytsaurus.client.request.RemoteCopyOperation;
import tech.ytsaurus.client.request.RemoveNode;
import tech.ytsaurus.client.request.SetNode;
import tech.ytsaurus.client.request.SortOperation;
import tech.ytsaurus.client.request.StartOperation;
import tech.ytsaurus.client.request.VanillaOperation;
import tech.ytsaurus.client.request.WriteFile;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.CypressNodeType;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.request.LockMode;
import tech.ytsaurus.rpcproxy.TCheckPermissionResult;
import tech.ytsaurus.ysontree.YTreeNode;

public interface TransactionalClient
extends ImmutableTransactionalClient {
    public TransactionalClient getRootClient();

    public CompletableFuture<GUID> createNode(CreateNode var1);

    @Deprecated
    default public CompletableFuture<GUID> createNode(CreateNode.BuilderBase<?> req) {
        return this.createNode(req.build());
    }

    public CompletableFuture<Void> removeNode(RemoveNode var1);

    @Deprecated
    default public CompletableFuture<Void> removeNode(RemoveNode.BuilderBase<?> req) {
        return this.removeNode(req.build());
    }

    public CompletableFuture<Void> setNode(SetNode var1);

    @Deprecated
    default public CompletableFuture<Void> setNode(SetNode.BuilderBase<?> req) {
        return this.setNode(req.build());
    }

    public CompletableFuture<YTreeNode> getNode(GetNode var1);

    @Deprecated
    default public CompletableFuture<YTreeNode> getNode(GetNode.BuilderBase<?> getNode) {
        return this.getNode(getNode.build());
    }

    public CompletableFuture<YTreeNode> listNode(ListNode var1);

    @Deprecated
    default public CompletableFuture<YTreeNode> listNode(ListNode.BuilderBase<?> listNode) {
        return this.listNode(listNode.build());
    }

    public CompletableFuture<LockNodeResult> lockNode(LockNode var1);

    @Deprecated
    default public CompletableFuture<LockNodeResult> lockNode(LockNode.BuilderBase<?> req) {
        return this.lockNode(req.build());
    }

    public CompletableFuture<GUID> copyNode(CopyNode var1);

    @Deprecated
    default public CompletableFuture<GUID> copyNode(CopyNode.BuilderBase<?> req) {
        return this.copyNode(req.build());
    }

    public CompletableFuture<GUID> linkNode(LinkNode var1);

    @Deprecated
    default public CompletableFuture<GUID> linkNode(LinkNode.BuilderBase<?> req) {
        return this.linkNode(req.build());
    }

    public CompletableFuture<GUID> moveNode(MoveNode var1);

    @Deprecated
    default public CompletableFuture<GUID> moveNode(MoveNode.BuilderBase<?> req) {
        return this.moveNode(req.build());
    }

    public CompletableFuture<Boolean> existsNode(ExistsNode var1);

    @Deprecated
    default public CompletableFuture<Boolean> existsNode(ExistsNode.BuilderBase<?> req) {
        return this.existsNode(req.build());
    }

    public CompletableFuture<Void> concatenateNodes(ConcatenateNodes var1);

    @Deprecated
    default public CompletableFuture<Void> concatenateNodes(ConcatenateNodes.BuilderBase<?> req) {
        return this.concatenateNodes(req.build());
    }

    public CompletableFuture<List<MultiTablePartition>> partitionTables(PartitionTables var1);

    public CompletableFuture<Void> advanceConsumer(AdvanceConsumer var1);

    @Deprecated
    default public <T> CompletableFuture<TableReader<T>> readTable(ReadTable.BuilderBase<T, ?> req) {
        return this.readTable((ReadTable<T>)req.build());
    }

    @Deprecated
    default public <T> CompletableFuture<TableReader<T>> readTable(ReadTable.BuilderBase<T, ?> req, @Nullable TableAttachmentReader<T> reader) {
        if (reader != null) {
            req.setSerializationContext(new ReadSerializationContext<T>(reader));
        }
        return this.readTable((ReadTable<T>)req.build());
    }

    public <T> CompletableFuture<TableReader<T>> readTable(ReadTable<T> var1);

    public <T> CompletableFuture<AsyncReader<T>> readTableV2(ReadTable<T> var1);

    default public CompletableFuture<TableReader<byte[]>> readTableDirect(ReadTableDirect req) {
        return this.readTable(req);
    }

    public <T> CompletableFuture<TableWriter<T>> writeTable(WriteTable<T> var1);

    @Deprecated
    default public <T> CompletableFuture<TableWriter<T>> writeTable(WriteTable.BuilderBase<T, ?> req) {
        return this.writeTable((WriteTable<T>)req.build());
    }

    public <T> CompletableFuture<AsyncWriter<T>> writeTableV2(WriteTable<T> var1);

    public CompletableFuture<FileReader> readFile(ReadFile var1);

    @Deprecated
    default public CompletableFuture<FileReader> readFile(ReadFile.BuilderBase<?> req) {
        return this.readFile(req.build());
    }

    public CompletableFuture<FileWriter> writeFile(WriteFile var1);

    @Deprecated
    default public CompletableFuture<FileWriter> writeFile(WriteFile.BuilderBase<?> req) {
        return this.writeFile(req.build());
    }

    public CompletableFuture<GUID> startOperation(StartOperation var1);

    @Deprecated
    default public CompletableFuture<GUID> startOperation(StartOperation.BuilderBase<?> req) {
        return this.startOperation(req.build());
    }

    public CompletableFuture<Operation> startMap(MapOperation var1);

    default public CompletableFuture<Operation> map(MapOperation req) {
        return this.startMap(req).thenCompose(op -> op.watch().thenApply(unused -> op));
    }

    public CompletableFuture<Operation> startReduce(ReduceOperation var1);

    default public CompletableFuture<Operation> reduce(ReduceOperation req) {
        return this.startReduce(req).thenCompose(op -> op.watch().thenApply(unused -> op));
    }

    public CompletableFuture<Operation> startSort(SortOperation var1);

    default public CompletableFuture<Operation> sort(SortOperation req) {
        return this.startSort(req).thenCompose(op -> op.watch().thenApply(unused -> op));
    }

    public CompletableFuture<Operation> startMapReduce(MapReduceOperation var1);

    default public CompletableFuture<Operation> mapReduce(MapReduceOperation req) {
        return this.startMapReduce(req).thenCompose(op -> op.watch().thenApply(unused -> op));
    }

    public CompletableFuture<Operation> startMerge(MergeOperation var1);

    default public CompletableFuture<Operation> merge(MergeOperation req) {
        return this.startMerge(req).thenCompose(op -> op.watch().thenApply(unused -> op));
    }

    public CompletableFuture<Operation> startRemoteCopy(RemoteCopyOperation var1);

    public Operation attachOperation(GUID var1);

    default public CompletableFuture<Operation> remoteCopy(RemoteCopyOperation req) {
        return this.startRemoteCopy(req).thenCompose(op -> op.watch().thenApply(unused -> op));
    }

    public CompletableFuture<Operation> startVanilla(VanillaOperation var1);

    default public CompletableFuture<Operation> vanilla(VanillaOperation req) {
        return this.startVanilla(req).thenCompose(op -> op.watch().thenApply(unused -> op));
    }

    public CompletableFuture<TCheckPermissionResult> checkPermission(CheckPermission var1);

    public CompletableFuture<GetFileFromCacheResult> getFileFromCache(GetFileFromCache var1);

    public CompletableFuture<PutFileToCacheResult> putFileToCache(PutFileToCache var1);

    default public CompletableFuture<YTreeNode> getNode(YPath path) {
        return this.getNode(((GetNode.Builder)GetNode.builder().setPath(path)).build());
    }

    default public CompletableFuture<YTreeNode> getNode(String path) {
        return this.getNode(path, null);
    }

    default public CompletableFuture<YTreeNode> getNode(String path, @Nullable Duration requestTimeout) {
        return this.getNode(((GetNode.Builder)((GetNode.Builder)GetNode.builder().setPath(YPath.simple((String)path))).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<YTreeNode> listNode(YPath path) {
        return this.listNode(((ListNode.Builder)ListNode.builder().setPath(path)).build());
    }

    default public CompletableFuture<YTreeNode> listNode(String path) {
        return this.listNode(path, null);
    }

    default public CompletableFuture<YTreeNode> listNode(String path, @Nullable Duration requestTimeout) {
        return this.listNode(((ListNode.Builder)((ListNode.Builder)ListNode.builder().setPath(YPath.simple((String)path))).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<Void> setNode(String path, byte[] data) {
        return this.setNode(path, data, null);
    }

    default public CompletableFuture<Void> setNode(String path, byte[] data, @Nullable Duration requestTimeout) {
        return this.setNode(((SetNode.Builder)((SetNode.Builder)((SetNode.Builder)SetNode.builder().setPath(YPath.simple((String)path))).setValue(data)).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<Void> setNode(String path, YTreeNode data) {
        return this.setNode(path, data.toBinary());
    }

    default public CompletableFuture<Void> setNode(String path, YTreeNode data, @Nullable Duration requestTimeout) {
        return this.setNode(path, data.toBinary(), requestTimeout);
    }

    default public CompletableFuture<Boolean> existsNode(String path) {
        return this.existsNode(path, null);
    }

    default public CompletableFuture<Boolean> existsNode(String path, @Nullable Duration requestTimeout) {
        return this.existsNode(((ExistsNode.Builder)((ExistsNode.Builder)ExistsNode.builder().setPath(YPath.simple((String)path))).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<GUID> createNode(String path, CypressNodeType type) {
        return this.createNode(new CreateNode(YPath.simple((String)path), type));
    }

    default public CompletableFuture<GUID> createNode(String path, CypressNodeType type, @Nullable Duration requestTimeout) {
        return this.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(YPath.simple((String)path))).setType(type)).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<GUID> createNode(String path, CypressNodeType type, Map<String, YTreeNode> attributes) {
        return this.createNode(path, type, attributes, null);
    }

    default public CompletableFuture<GUID> createNode(String path, CypressNodeType type, Map<String, YTreeNode> attributes, @Nullable Duration requestTimeout) {
        return this.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(YPath.simple((String)path))).setType(type)).setAttributes(attributes)).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<Void> removeNode(String path) {
        return this.removeNode(new RemoveNode(YPath.simple((String)path)));
    }

    default public CompletableFuture<LockNodeResult> lockNode(String path, LockMode mode) {
        return this.lockNode(path, mode, null);
    }

    default public CompletableFuture<LockNodeResult> lockNode(String path, LockMode mode, @Nullable Duration requestTimeout) {
        return this.lockNode(((LockNode.Builder)((LockNode.Builder)((LockNode.Builder)LockNode.builder().setPath(YPath.simple((String)path))).setMode(mode)).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<GUID> copyNode(String src, String dst) {
        return this.copyNode(src, dst, null);
    }

    default public CompletableFuture<GUID> copyNode(String src, String dst, @Nullable Duration requestTimeout) {
        return this.copyNode(((CopyNode.Builder)((CopyNode.Builder)((CopyNode.Builder)CopyNode.builder().setSource(src)).setDestination(dst)).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<GUID> moveNode(String from, String to) {
        return this.moveNode(from, to, null);
    }

    default public CompletableFuture<GUID> moveNode(String from, String to, @Nullable Duration requestTimeout) {
        return this.moveNode(((MoveNode.Builder)((MoveNode.Builder)((MoveNode.Builder)MoveNode.builder().setSource(from)).setDestination(to)).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<GUID> linkNode(String src, String dst) {
        return this.linkNode(new LinkNode(src, dst));
    }

    default public CompletableFuture<Void> concatenateNodes(String[] from, String to) {
        return this.concatenateNodes(from, to, null);
    }

    default public CompletableFuture<Void> concatenateNodes(String[] from, String to, @Nullable Duration requestTimeout) {
        return this.concatenateNodes(((ConcatenateNodes.Builder)((ConcatenateNodes.Builder)((ConcatenateNodes.Builder)ConcatenateNodes.builder().setSourcePaths(Arrays.stream(from).map(YPath::simple).collect(Collectors.toList()))).setDestinationPath(YPath.simple((String)to))).setTimeout(requestTimeout)).build());
    }
}

