/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import tech.ytsaurus.client.DataSupplier;
import tech.ytsaurus.client.rpc.Codec;

class WrappedSupplier
implements DataSupplier {
    private final DataSupplier supplier;
    private final Codec inputCodec;
    private boolean eof;

    WrappedSupplier(DataSupplier supplier, Codec inputCodec) {
        this.supplier = supplier;
        this.inputCodec = inputCodec;
    }

    @Override
    public byte[] get() {
        byte[] data = this.supplier.get();
        this.eof = data == null;
        return data;
    }

    @Override
    public int put(byte[] data) {
        if (this.eof) {
            throw new IllegalArgumentException();
        }
        if (data == null) {
            return this.supplier.put(null);
        }
        return this.supplier.put(this.inputCodec.compress(data));
    }

    @Override
    public boolean hasData() {
        return !this.eof && this.supplier.hasData();
    }
}

