/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.MessageLite;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.ApiServiceClientImpl;
import tech.ytsaurus.client.BaseYTsaurusClient;
import tech.ytsaurus.client.ClientPoolService;
import tech.ytsaurus.client.CompoundClientImpl;
import tech.ytsaurus.client.DefaultSerializationResolver;
import tech.ytsaurus.client.DiscoveryMethod;
import tech.ytsaurus.client.HostPort;
import tech.ytsaurus.client.MultiDcClientPool;
import tech.ytsaurus.client.NonRepeatingClientPool;
import tech.ytsaurus.client.OutageController;
import tech.ytsaurus.client.OutageRpcClientFactoryImpl;
import tech.ytsaurus.client.RpcClientFactory;
import tech.ytsaurus.client.RpcClientFactoryImpl;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.YTsaurusClientConfig;
import tech.ytsaurus.client.YTsaurusCluster;
import tech.ytsaurus.client.bus.BusConnector;
import tech.ytsaurus.client.bus.DefaultBusConnector;
import tech.ytsaurus.client.rpc.DataCenterMetricsHolderImpl;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientPool;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcCompression;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.client.rpc.YTsaurusClientAuth;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpc.TResponseHeader;
import tech.ytsaurus.rpc.TStreamingFeedbackHeader;
import tech.ytsaurus.rpc.TStreamingPayloadHeader;

public class YTsaurusClient
extends CompoundClientImpl
implements BaseYTsaurusClient {
    private final BusConnector busConnector;
    private final boolean isBusConnectorOwner;
    private final ScheduledExecutorService executor;
    private final ClientPoolProvider poolProvider;
    private final List<YTsaurusCluster> clusters;

    public YTsaurusClient(BusConnector connector, YTsaurusCluster cluster, YTsaurusClientAuth auth, YTsaurusClientConfig config) {
        this(new BuilderWithDefaults((ClientBuilder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setSharedBusConnector(connector)).setClusters(List.of(cluster))).setPreferredClusterName(cluster.getName())).setAuth(auth)).setRpcCompression(new RpcCompression())).setConfig(config)), DefaultSerializationResolver.getInstance());
    }

    public YTsaurusClient(BusConnector connector, String clusterName, YTsaurusClientAuth auth, YTsaurusClientConfig config) {
        this(connector, new YTsaurusCluster(clusterName), auth, config);
    }

    public YTsaurusClient(BusConnector connector, String clusterName, YTsaurusClientAuth auth) {
        this(connector, clusterName, auth, YTsaurusClientConfig.builder().setRpcOptions(new RpcOptions()).build());
    }

    protected YTsaurusClient(BuilderWithDefaults<?, ?> builder, SerializationResolver serializationResolver) {
        super(builder.busConnector.executorService(), builder.builder.config, builder.builder.heavyExecutor, serializationResolver);
        builder.builder.validate();
        this.busConnector = builder.busConnector;
        this.isBusConnectorOwner = builder.builder.isBusConnectorOwner;
        this.executor = this.busConnector.executorService();
        this.clusters = builder.builder.clusters;
        OutageController outageController = builder.builder.config.getRpcOptions().getTestingOptions().getOutageController();
        RpcClientFactoryImpl rpcClientFactory = outageController != null ? new OutageRpcClientFactoryImpl(this.busConnector, builder.auth, builder.builder.compression, outageController) : new RpcClientFactoryImpl(this.busConnector, builder.auth, builder.builder.compression);
        this.poolProvider = new ClientPoolProvider(this.busConnector, builder.builder.clusters, builder.builder.preferredClusterName, builder.builder.proxyRole, builder.builder.proxyNetworkName, builder.builder.config.getUseTLS(), builder.builder.config.getTvmOnly(), builder.builder.config.getIgnoreBalancers(), builder.auth, rpcClientFactory, builder.builder.config.getRpcOptions(), builder.builder.heavyExecutor);
    }

    public static YTsaurusClient of(String cluster) {
        return (YTsaurusClient)((BaseBuilder)YTsaurusClient.builder().setCluster(cluster)).build();
    }

    public static ClientBuilder<? extends YTsaurusClient, ?> builder() {
        return new Builder();
    }

    @Override
    public List<YTsaurusCluster> getClusters() {
        return this.clusters;
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public CompletableFuture<Void> waitProxies() {
        return this.poolProvider.waitProxies();
    }

    @Override
    public void close() {
        this.poolProvider.close();
        if (this.isBusConnectorOwner) {
            this.busConnector.close();
        }
        super.close();
    }

    public Map<String, List<ApiServiceClient>> getAliveDestinations() {
        return this.poolProvider.getAliveDestinations();
    }

    public RpcClientPool getClientPool() {
        return this.poolProvider.getClientPool();
    }

    @Deprecated
    List<RpcClient> selectDestinations() {
        return this.poolProvider.oldSelectDestinations();
    }

    CompletableFuture<Void> banProxy(String address) {
        return this.poolProvider.banClient(address).thenApply(bannedCount -> {
            if (bannedCount == 0) {
                throw new RuntimeException("Cannot ban proxy " + address + " since it is not known");
            }
            return null;
        });
    }

    @Override
    protected <RequestType extends MessageLite.Builder, ResponseType extends MessageLite> CompletableFuture<RpcClientResponse<ResponseType>> invoke(RpcClientRequestBuilder<RequestType, ResponseType> builder) {
        return builder.invokeVia(this.executor, this.poolProvider.getClientPool());
    }

    @Override
    protected <RequestType extends MessageLite.Builder, ResponseType extends MessageLite> CompletableFuture<RpcClientStreamControl> startStream(RpcClientRequestBuilder<RequestType, ResponseType> builder, final RpcStreamConsumer consumer) {
        final CompletableFuture clientReleaseFuture = new CompletableFuture();
        RpcStreamConsumer wrappedConsumer = new RpcStreamConsumer(){

            @Override
            public void onStartStream(RpcClientStreamControl control) {
                consumer.onStartStream(control);
            }

            @Override
            public void onFeedback(RpcClient sender, TStreamingFeedbackHeader header, List<byte[]> attachments) {
                consumer.onFeedback(sender, header, attachments);
            }

            @Override
            public void onPayload(RpcClient sender, TStreamingPayloadHeader header, List<byte[]> attachments) {
                consumer.onPayload(sender, header, attachments);
            }

            @Override
            public void onResponse(RpcClient sender, TResponseHeader header, List<byte[]> attachments) {
                consumer.onResponse(sender, header, attachments);
                clientReleaseFuture.complete(null);
            }

            @Override
            public void onError(Throwable cause) {
                consumer.onError(cause);
                clientReleaseFuture.complete(null);
            }

            @Override
            public void onCancel(CancellationException cancel) {
                consumer.onCancel(cancel);
                clientReleaseFuture.complete(null);
            }

            @Override
            public void onWakeup() {
                consumer.onWakeup();
            }
        };
        CompletableFuture<RpcClient> clientFuture = this.getClientPool().peekClient(clientReleaseFuture);
        return clientFuture.thenApply(client -> client.startStream((RpcClient)client, builder.getRpcRequest(), wrappedConsumer, builder.getOptions()));
    }

    @NonNullFields
    public static class BuilderWithDefaults<TClient, TBuilder extends ClientBuilder<TClient, TBuilder>> {
        final ClientBuilder<TClient, TBuilder> builder;
        final BusConnector busConnector;
        final YTsaurusClientAuth auth;

        public BuilderWithDefaults(ClientBuilder<TClient, TBuilder> builder) {
            this.builder = builder;
            this.busConnector = Objects.requireNonNullElseGet(builder.busConnector, DefaultBusConnector::new);
            this.auth = Objects.requireNonNullElseGet(builder.auth, YTsaurusClientAuth::loadUserAndTokenFromEnvironment);
        }
    }

    @NonNullFields
    @NonNullApi
    public static abstract class ClientBuilder<TClient, TBuilder extends ClientBuilder<TClient, TBuilder>>
    extends BaseBuilder<TClient, TBuilder> {
        @Nullable
        BusConnector busConnector;
        boolean isBusConnectorOwner = true;
        @Nullable
        String preferredClusterName;
        @Nullable
        String proxyRole;
        @Nullable
        String proxyNetworkName;
        List<YTsaurusCluster> clusters = new ArrayList<YTsaurusCluster>();
        boolean enableValidation = true;
        Executor heavyExecutor = ForkJoinPool.commonPool();

        protected ClientBuilder() {
        }

        public TBuilder setClusters(String firstCluster, String ... rest) {
            ArrayList<YTsaurusCluster> clustersList = new ArrayList<YTsaurusCluster>();
            clustersList.add(new YTsaurusCluster(YTsaurusCluster.normalizeName(firstCluster)));
            for (String clusterName : rest) {
                clustersList.add(new YTsaurusCluster(YTsaurusCluster.normalizeName(clusterName)));
            }
            return this.setClusters(clustersList);
        }

        public TBuilder setClusters(List<YTsaurusCluster> clusters) {
            this.clusters = clusters;
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setOwnBusConnector(BusConnector connector) {
            this.busConnector = connector;
            this.isBusConnectorOwner = true;
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setSharedBusConnector(BusConnector connector) {
            this.busConnector = connector;
            this.isBusConnectorOwner = false;
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setCluster(String cluster) {
            this.setClusters(cluster, new String[0]);
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setHeavyExecutor(Executor heavyExecutor) {
            this.heavyExecutor = heavyExecutor;
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setDefaultBusConnectorWithThreadCount(int threadCount) {
            NioEventLoopGroup nioGroup = new NioEventLoopGroup(threadCount, (ThreadFactory)new DefaultThreadFactory(DefaultBusConnector.class, true, 5));
            this.setOwnBusConnector(new DefaultBusConnector((EventLoopGroup)nioGroup, true));
            this.isBusConnectorOwner = true;
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setPreferredClusterName(@Nullable String preferredClusterName) {
            this.preferredClusterName = YTsaurusCluster.normalizeName(preferredClusterName);
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setProxyRole(@Nullable String proxyRole) {
            this.proxyRole = proxyRole;
            return (TBuilder)((ClientBuilder)this.self());
        }

        public TBuilder setProxyNetworkName(@Nullable String proxyNetworkName) {
            this.proxyNetworkName = proxyNetworkName;
            return (TBuilder)((ClientBuilder)this.self());
        }

        protected <C, B extends ClientBuilder<C, B>> ClientBuilder<C, B> copyTo(ClientBuilder<C, B> builder) {
            builder.auth = this.auth;
            builder.compression = this.compression;
            builder.config = this.config;
            builder.busConnector = this.busConnector;
            builder.isBusConnectorOwner = this.isBusConnectorOwner;
            builder.preferredClusterName = this.preferredClusterName;
            builder.proxyRole = this.proxyRole;
            builder.clusters = this.clusters;
            builder.enableValidation = this.enableValidation;
            builder.heavyExecutor = this.heavyExecutor;
            builder.proxyNetworkName = this.proxyNetworkName;
            return builder;
        }

        void validate() {
            if (!this.enableValidation) {
                return;
            }
            if (this.clusters.isEmpty()) {
                throw new IllegalArgumentException("No YT cluster specified");
            }
            HashSet<String> clusterNames = new HashSet<String>();
            boolean foundPreferredCluster = false;
            for (YTsaurusCluster cluster : this.clusters) {
                if (clusterNames.contains(cluster.name)) {
                    throw new IllegalArgumentException(String.format("Cluster %s is specified multiple times", cluster.name));
                }
                clusterNames.add(cluster.name);
                if (!cluster.name.equals(this.preferredClusterName)) continue;
                foundPreferredCluster = true;
            }
            if (this.preferredClusterName != null && !foundPreferredCluster) {
                throw new IllegalArgumentException(String.format("Preferred cluster %s is not found among specified clusters", this.preferredClusterName));
            }
        }

        TBuilder disableValidation() {
            this.enableValidation = false;
            return (TBuilder)((ClientBuilder)this.self());
        }
    }

    @NonNullApi
    @NonNullFields
    public static class Builder
    extends ClientBuilder<YTsaurusClient, Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public YTsaurusClient build() {
            return new YTsaurusClient(new BuilderWithDefaults<YTsaurusClient, Builder>(this), DefaultSerializationResolver.getInstance());
        }
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BaseBuilder<TClient, TBuilder extends BaseBuilder<TClient, TBuilder>> {
        @Nullable
        YTsaurusClientAuth auth;
        RpcCompression compression = new RpcCompression();
        YTsaurusClientConfig config = YTsaurusClientConfig.builder().setRpcOptions(new RpcOptions()).build();

        public TBuilder setAuth(@Nullable YTsaurusClientAuth auth) {
            this.auth = auth;
            return this.self();
        }

        public TBuilder setRpcCompression(RpcCompression rpcCompression) {
            this.compression = rpcCompression;
            return this.self();
        }

        @Deprecated
        public TBuilder setRpcOptions(RpcOptions rpcOptions) {
            this.config = YTsaurusClientConfig.builder().setRpcOptions(rpcOptions).build();
            return this.self();
        }

        public TBuilder setConfig(YTsaurusClientConfig config) {
            this.config = config;
            return this.self();
        }

        protected abstract TBuilder self();

        public abstract TClient build();
    }

    @NonNullApi
    static class ClientPoolProvider
    implements AutoCloseable {
        final MultiDcClientPool multiDcClientPool;
        final List<ClientPoolService> dataCenterList = new ArrayList<ClientPoolService>();
        final String localDcName;
        final RpcOptions options;
        final Executor heavyExecutor;
        final ScheduledExecutorService executorService;

        ClientPoolProvider(BusConnector connector, List<YTsaurusCluster> clusters, @Nullable String localDataCenterName, @Nullable String proxyRole, @Nullable String proxyNetworkName, boolean useTLS, boolean tvmOnly, boolean ignoreBalancers, YTsaurusClientAuth auth, RpcClientFactory rpcClientFactory, RpcOptions options, Executor heavyExecutor) {
            this.options = options;
            this.localDcName = localDataCenterName;
            this.heavyExecutor = heavyExecutor;
            this.executorService = connector.executorService();
            EventLoopGroup eventLoopGroup = connector.eventLoopGroup();
            Random random = new Random();
            for (YTsaurusCluster curCluster : clusters) {
                if (curCluster.balancerFqdn != null && !curCluster.balancerFqdn.isEmpty() && (options.getPreferableDiscoveryMethod() == DiscoveryMethod.HTTP || curCluster.addresses == null || curCluster.addresses.isEmpty())) {
                    this.dataCenterList.add(((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)((ClientPoolService.HttpBuilder)ClientPoolService.httpBuilder().setDataCenterName(curCluster.getName())).setBalancerFqdn(curCluster.balancerFqdn).setBalancerPort(curCluster.port).setRole(proxyRole)).setProxyNetworkName(proxyNetworkName)).setUseTLS(useTLS || curCluster.useTLS)).setTvmOnly(tvmOnly)).setIgnoreBalancers(ignoreBalancers)).setToken(auth.getToken().orElse(null))).setOptions(options)).setClientFactory(rpcClientFactory)).setEventLoop(eventLoopGroup)).setRandom(random)).build());
                    continue;
                }
                if (curCluster.addresses != null && !curCluster.addresses.isEmpty() && (options.getPreferableDiscoveryMethod() == DiscoveryMethod.RPC || curCluster.balancerFqdn == null || curCluster.balancerFqdn.isEmpty())) {
                    List<HostPort> initialProxyList = curCluster.addresses.stream().map(HostPort::parse).collect(Collectors.toList());
                    this.dataCenterList.add(((ClientPoolService.RpcBuilder)((ClientPoolService.RpcBuilder)((ClientPoolService.RpcBuilder)((ClientPoolService.RpcBuilder)((ClientPoolService.RpcBuilder)((ClientPoolService.RpcBuilder)ClientPoolService.rpcBuilder().setDataCenterName(curCluster.getName())).setInitialProxyList(initialProxyList).setRole(proxyRole)).setOptions(options)).setClientFactory(rpcClientFactory)).setEventLoop(eventLoopGroup)).setRandom(random)).build());
                    continue;
                }
                throw new RuntimeException(String.format("Cluster %s does not have neither http balancer nor rpc proxies specified ", curCluster.getName()));
            }
            for (ClientPoolService clientPoolService : this.dataCenterList) {
                clientPoolService.start();
            }
            this.multiDcClientPool = MultiDcClientPool.builder().setLocalDc(localDataCenterName).addClientPools(this.dataCenterList).setDcMetricHolder(DataCenterMetricsHolderImpl.INSTANCE).build();
        }

        @Override
        public void close() {
            for (ClientPoolService dataCenter : this.dataCenterList) {
                dataCenter.close();
            }
        }

        public CompletableFuture<Void> waitProxies() {
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            CompletableFuture<RpcClient> client = this.multiDcClientPool.peekClient(result);
            client.whenComplete((c, error) -> {
                if (error != null) {
                    result.completeExceptionally((Throwable)error);
                } else {
                    result.complete(null);
                }
            });
            RpcUtil.relayCancel(result, client);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, List<ApiServiceClient>> getAliveDestinations() {
            HashMap<String, List<ApiServiceClient>> result = new HashMap<String, List<ApiServiceClient>>();
            CompletableFuture<Object> releaseFuture = new CompletableFuture<Object>();
            try {
                for (ClientPoolService clientPoolService : this.dataCenterList) {
                    RpcClient[] aliveClients = clientPoolService.getAliveClients();
                    if (aliveClients.length == 0) continue;
                    List clients = result.computeIfAbsent(clientPoolService.getDataCenterName(), k -> new ArrayList());
                    for (RpcClient curClient : aliveClients) {
                        clients.add(new ApiServiceClientImpl(curClient, YTsaurusClientConfig.builder().setRpcOptions(this.options).build(), this.heavyExecutor, this.executorService, DefaultSerializationResolver.getInstance()));
                    }
                }
            }
            finally {
                releaseFuture.complete(null);
            }
            return result;
        }

        public List<RpcClient> oldSelectDestinations() {
            int resultSize = 3;
            ArrayList<RpcClient> result = new ArrayList<RpcClient>();
            Consumer<ClientPoolService> processClientPoolService = service -> {
                RpcClient[] aliveClients;
                for (RpcClient c : aliveClients = service.getAliveClients()) {
                    if (result.size() >= 3) break;
                    result.add(c);
                }
            };
            for (ClientPoolService clientPoolService : this.dataCenterList) {
                if (!clientPoolService.getDataCenterName().equals(this.localDcName)) continue;
                processClientPoolService.accept(clientPoolService);
            }
            for (ClientPoolService clientPoolService : this.dataCenterList) {
                if (clientPoolService.getDataCenterName().equals(this.localDcName)) continue;
                processClientPoolService.accept(clientPoolService);
            }
            return result;
        }

        public RpcClientPool getClientPool() {
            return new NonRepeatingClientPool(this.multiDcClientPool);
        }

        public CompletableFuture<Integer> banClient(String address) {
            return this.multiDcClientPool.banClient(address);
        }
    }
}

