/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.bus.Bus;
import tech.ytsaurus.client.bus.BusListener;

class BusListenerWrapper
implements BusListener {
    private static final Logger logger = LoggerFactory.getLogger(BusListenerWrapper.class);
    private final BusListener listener;

    BusListenerWrapper(BusListener listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    public BusListener getListener() {
        return this.listener;
    }

    @Override
    public void onMessage(Bus bus, List<byte[]> message) {
        try {
            this.listener.onMessage(bus, message);
        }
        catch (RuntimeException e) {
            logger.error("Unhandled exception in a listener", (Throwable)e);
        }
    }

    @Override
    public void onConnect(Bus bus) {
        try {
            this.listener.onConnect(bus);
        }
        catch (RuntimeException e) {
            logger.error("Unhandled exception in a listener", (Throwable)e);
        }
    }

    @Override
    public void onDisconnect(Bus bus) {
        try {
            this.listener.onDisconnect(bus);
        }
        catch (RuntimeException e) {
            logger.error("Unhandled exception in a listener", (Throwable)e);
        }
    }

    @Override
    public void onException(Bus bus, Throwable cause) {
        try {
            this.listener.onException(bus, cause);
        }
        catch (RuntimeException e) {
            logger.error("Unhandled exception in a listener", (Throwable)e);
        }
    }
}

