/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.bus.BusPacket;
import tech.ytsaurus.client.bus.BusPacketFixedHeader;
import tech.ytsaurus.client.bus.BusPacketVariableHeader;
import tech.ytsaurus.client.bus.BusPartDecoder;
import tech.ytsaurus.client.misc.YtCrc64;

class BusPacketDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BusPacketDecoder.class);
    private static final byte[] EMPTY_PART = new byte[0];
    private final BusPartDecoder partDecoder = new BusPartDecoder();
    private final boolean verifyChecksums;
    private State state = State.FIXED_HEADER;
    private BusPacketFixedHeader header;
    private BusPacketVariableHeader vheader;
    private List<byte[]> message;

    BusPacketDecoder() {
        this(true);
    }

    BusPacketDecoder(boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
    }

    private void reset() {
        this.state = State.FIXED_HEADER;
        this.header = null;
        this.vheader = null;
        this.message = null;
    }

    private boolean startNextMessagePart() {
        while (this.message.size() < this.header.getPartCount()) {
            int size = this.vheader.getSize(this.message.size());
            if (size == -1) {
                this.message.add(null);
                continue;
            }
            if (size == 0) {
                this.message.add(EMPTY_PART);
                continue;
            }
            this.partDecoder.start(size);
            return true;
        }
        return false;
    }

    private boolean readMessagePart(ByteBuf in) {
        byte[] part = this.partDecoder.read(in);
        if (part != null) {
            long actualChecksum;
            int index;
            long checksum;
            if (this.verifyChecksums && (checksum = this.vheader.getChecksum(index = this.message.size())) != 0L && (actualChecksum = YtCrc64.fromBytes(part)) != checksum) {
                throw new IllegalStateException("Packet " + String.valueOf(this.header.getPacketId()) + " part " + index + " checksum mismatch: expected=0x" + Long.toUnsignedString(checksum, 16) + ", actual=0x" + Long.toUnsignedString(actualChecksum, 16));
            }
            this.message.add(part);
            return true;
        }
        return false;
    }

    private BusPacket finishMessage() {
        BusPacket packet = new BusPacket(this.header.getType(), this.header.getFlags(), this.header.getPacketId(), this.message);
        logger.trace("Received packet: {}", (Object)packet);
        this.reset();
        return packet;
    }

    private BusPacket finishAck() {
        BusPacket packet = new BusPacket(this.header.getType(), this.header.getFlags(), this.header.getPacketId());
        logger.trace("Received packet: {}", (Object)packet);
        this.reset();
        return packet;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            switch (this.state) {
                case FIXED_HEADER: {
                    if (in.readableBytes() < 36) {
                        return;
                    }
                    this.header = BusPacketFixedHeader.readFrom(in, this.verifyChecksums);
                    switch (this.header.getType()) {
                        case MESSAGE: {
                            this.state = State.VARIABLE_HEADER;
                            break;
                        }
                        case ACK: {
                            out.add(this.finishAck());
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Packet " + String.valueOf(this.header.getPacketId()) + " has unexpected type " + String.valueOf((Object)this.header.getType()));
                        }
                    }
                }
                case VARIABLE_HEADER: {
                    if (in.readableBytes() < BusPacketVariableHeader.size(this.header.getPartCount())) {
                        return;
                    }
                    this.vheader = BusPacketVariableHeader.readFrom(this.header, in, this.verifyChecksums);
                    this.message = new ArrayList<byte[]>(this.header.getPartCount());
                    if (!this.startNextMessagePart()) {
                        out.add(this.finishMessage());
                        return;
                    }
                    this.state = State.PARTS;
                }
                case PARTS: {
                    while (this.readMessagePart(in)) {
                        if (this.startNextMessagePart()) continue;
                        out.add(this.finishMessage());
                        return;
                    }
                    break;
                }
                case ERROR: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Decoder has unexpected state " + String.valueOf((Object)this.state));
                }
            }
        }
        catch (Throwable e) {
            this.state = State.ERROR;
            throw e;
        }
    }

    private static enum State {
        FIXED_HEADER,
        VARIABLE_HEADER,
        PARTS,
        ERROR;

    }
}

