/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.bus.BusPacket;
import tech.ytsaurus.client.bus.BusPacketType;

class BusPacketEncoder
extends ChannelOutboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(BusPacketEncoder.class);
    private final boolean computeChecksums;

    BusPacketEncoder() {
        this(true);
    }

    BusPacketEncoder(boolean computeChecksums) {
        this.computeChecksums = computeChecksums;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof BusPacket) {
            BusPacket packet = (BusPacket)msg;
            logger.trace("Sending packet: {}", (Object)packet);
            ByteBuf buf = ctx.alloc().ioBuffer(packet.getHeadersSize());
            try {
                packet.writeHeadersTo(buf, this.computeChecksums);
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
            ctx.write((Object)buf);
            if (packet.getType() == BusPacketType.MESSAGE) {
                for (byte[] part : packet.getMessage()) {
                    if (part == null || part.length <= 0) continue;
                    ctx.write((Object)Unpooled.wrappedBuffer((byte[])part));
                }
            }
            ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

