/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.buffer.ByteBuf;
import java.nio.ByteOrder;
import java.util.Objects;
import tech.ytsaurus.client.bus.BusPacketType;
import tech.ytsaurus.client.bus.BusUtil;
import tech.ytsaurus.client.misc.YtCrc64;
import tech.ytsaurus.core.GUID;

class BusPacketFixedHeader {
    public static final int SIZE = 36;
    private final BusPacketType type;
    private final short flags;
    private final GUID packetId;
    private final int partCount;

    BusPacketFixedHeader(BusPacketType type, short flags, GUID packetId, int partCount) {
        this.type = Objects.requireNonNull(type);
        this.flags = flags;
        this.packetId = Objects.requireNonNull(packetId);
        this.partCount = partCount;
    }

    public BusPacketType getType() {
        return this.type;
    }

    public short getFlags() {
        return this.flags;
    }

    public GUID getPacketId() {
        return this.packetId;
    }

    public int getPartCount() {
        return this.partCount;
    }

    public static BusPacketFixedHeader readFrom(ByteBuf in, boolean verifyChecksums) {
        long actualChecksum;
        in = in.order(ByteOrder.LITTLE_ENDIAN);
        int start = in.readerIndex();
        int signature = in.readInt();
        if (signature != 2019650895) {
            throw new IllegalStateException("Packet signature mismatch: " + Integer.toUnsignedString(signature, 16));
        }
        BusPacketType type = BusPacketType.fromValue(in.readShort());
        short flags = in.readShort();
        GUID packetId = BusUtil.readGuidFrom(in);
        int partCount = in.readInt();
        int end = in.readerIndex();
        long checksum = in.readLong();
        if (verifyChecksums && checksum != 0L && (actualChecksum = YtCrc64.fromBytes(in.slice(start, end - start))) != checksum) {
            throw new IllegalStateException("Packet " + String.valueOf(packetId) + " header checksum mismatch: expected=0x" + Long.toUnsignedString(checksum, 16) + ", actual=0x" + Long.toUnsignedString(actualChecksum, 16));
        }
        if (partCount < 0 || partCount > 0x10000000) {
            throw new IllegalStateException("Packet has " + partCount + " part, maximum allowed is 268435456");
        }
        return new BusPacketFixedHeader(type, flags, packetId, partCount);
    }

    public void writeTo(ByteBuf out, boolean computeChecksums) {
        out = out.order(ByteOrder.LITTLE_ENDIAN);
        int start = out.writerIndex();
        out.writeInt(2019650895);
        out.writeShort((int)this.type.getValue());
        out.writeShort((int)this.flags);
        BusUtil.writeTo(out, this.packetId);
        out.writeInt(this.partCount);
        int end = out.writerIndex();
        long checksum = 0L;
        if (computeChecksums) {
            checksum = YtCrc64.fromBytes(out.slice(start, end - start));
        }
        out.writeLong(checksum);
    }
}

