/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import java.util.HashMap;
import java.util.Map;

enum BusPacketType {
    MESSAGE(0),
    ACK(1);

    private final short value;
    private static final Map<Short, BusPacketType> INDEX;

    private BusPacketType(int value) {
        this.value = (short)value;
    }

    public short getValue() {
        return this.value;
    }

    public static BusPacketType fromValue(short value) {
        BusPacketType busPacketType = INDEX.get(value);
        if (busPacketType == null) {
            throw new IllegalArgumentException("Unsupported bus packet type " + value);
        }
        return busPacketType;
    }

    static {
        INDEX = new HashMap<Short, BusPacketType>();
        for (BusPacketType busPacketType : BusPacketType.values()) {
            INDEX.put(busPacketType.getValue(), busPacketType);
        }
    }
}

