/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.buffer.ByteBuf;
import java.nio.ByteOrder;
import java.util.List;
import tech.ytsaurus.client.bus.BusPacketFixedHeader;
import tech.ytsaurus.client.misc.YtCrc64;

class BusPacketVariableHeader {
    private final int[] sizes;
    private final long[] checksums;

    BusPacketVariableHeader(int[] sizes, long[] checksums) {
        if (sizes.length != checksums.length) {
            throw new IllegalArgumentException("sizes and checksums must have identical sizes");
        }
        this.sizes = sizes;
        this.checksums = checksums;
    }

    public int getSize(int index) {
        return this.sizes[index];
    }

    public long getChecksum(int index) {
        return this.checksums[index];
    }

    public int partCount() {
        return this.sizes.length;
    }

    public static int size(int partCount) {
        return 12 * partCount + 8;
    }

    public static BusPacketVariableHeader readFrom(BusPacketFixedHeader header, ByteBuf in, boolean verifyChecksums) {
        long actualChecksum;
        in = in.order(ByteOrder.LITTLE_ENDIAN);
        int start = in.readerIndex();
        int[] sizes = new int[header.getPartCount()];
        for (int i = 0; i < header.getPartCount(); ++i) {
            sizes[i] = in.readInt();
        }
        long[] checksums = new long[header.getPartCount()];
        for (int i = 0; i < header.getPartCount(); ++i) {
            checksums[i] = in.readLong();
        }
        int end = in.readerIndex();
        long checksum = in.readLong();
        if (verifyChecksums && checksum != 0L && (actualChecksum = YtCrc64.fromBytes(in.slice(start, end - start))) != checksum) {
            throw new IllegalStateException("Packet " + String.valueOf(header.getPacketId()) + " variable header checksum mismatch: expected=0x" + Long.toUnsignedString(checksum, 16) + ", actual=0x" + Long.toUnsignedString(actualChecksum, 16));
        }
        for (int i = 0; i < header.getPartCount(); ++i) {
            if (sizes[i] == -1 || sizes[i] >= 0 && sizes[i] <= 0x10000000) continue;
            throw new IllegalStateException("Packet has part with " + sizes[i] + " bytes, maximum allowed is 268435456");
        }
        return new BusPacketVariableHeader(sizes, checksums);
    }

    public static void writeTo(List<byte[]> message, ByteBuf out, boolean computeChecksums) {
        out = out.order(ByteOrder.LITTLE_ENDIAN);
        int start = out.writerIndex();
        for (byte[] part : message) {
            int size = part != null ? part.length : -1;
            out.writeInt(size);
        }
        for (byte[] part : message) {
            long checksum = computeChecksums && part != null ? YtCrc64.fromBytes(part) : 0L;
            out.writeLong(checksum);
        }
        int end = out.writerIndex();
        long checksum = computeChecksums ? YtCrc64.fromBytes(out.slice(start, end - start)) : 0L;
        out.writeLong(checksum);
    }
}

