/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.bus.Bus;
import tech.ytsaurus.client.bus.BusDeliveryTracking;
import tech.ytsaurus.client.bus.BusLifecycle;
import tech.ytsaurus.client.bus.BusListener;
import tech.ytsaurus.client.bus.BusListenerWrapper;
import tech.ytsaurus.client.bus.BusOutgoingMessage;
import tech.ytsaurus.client.bus.BusPacket;
import tech.ytsaurus.client.bus.BusPacketType;
import tech.ytsaurus.core.GUID;

class BusProtocolHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(BusProtocolHandler.class);
    private final Bus bus;
    private final BusListenerWrapper wrappedListener;
    private final Deque<DeliveryEntry> deliveryQueue = new ArrayDeque<DeliveryEntry>();

    BusProtocolHandler(Bus bus, BusListener listener) {
        this.bus = bus;
        this.wrappedListener = new BusListenerWrapper(listener);
    }

    private void abortDelivery(Throwable cause) {
        DeliveryEntry entry;
        while ((entry = this.deliveryQueue.pollFirst()) != null) {
            entry.getPromise().tryFailure(cause);
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public BusListener getListener() {
        return this.wrappedListener.getListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.debug("Unhandled exception", cause);
        try {
            try {
                try {
                    this.abortDelivery(cause);
                }
                finally {
                    this.wrappedListener.onException(this.bus, cause);
                }
            }
            finally {
                if (this.bus instanceof BusLifecycle) {
                    ((BusLifecycle)((Object)this.bus)).channelFailed(cause);
                }
            }
        }
        finally {
            ctx.close();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (this.bus instanceof BusLifecycle) {
            ((BusLifecycle)((Object)this.bus)).channelConnected();
        }
        this.wrappedListener.onConnect(this.bus);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            try {
                this.abortDelivery(new ClosedChannelException());
            }
            finally {
                this.wrappedListener.onDisconnect(this.bus);
            }
        }
        finally {
            if (this.bus instanceof BusLifecycle) {
                ((BusLifecycle)((Object)this.bus)).channelDisconnected();
            }
        }
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof BusPacket) {
            BusPacket packet = (BusPacket)msg;
            switch (packet.getType()) {
                case ACK: {
                    DeliveryEntry entry = this.deliveryQueue.peekFirst();
                    if (entry == null) {
                        ctx.close();
                        throw new IllegalStateException("Received unexpected ack for packet " + String.valueOf(packet.getPacketId()));
                    }
                    if (!entry.getPacketId().equals((Object)packet.getPacketId())) {
                        ctx.close();
                        throw new IllegalStateException("Received unexpected ack for packet " + String.valueOf(packet.getPacketId()) + " while waiting for packet " + String.valueOf(entry.getPacketId()));
                    }
                    this.deliveryQueue.removeFirst();
                    entry.getPromise().trySuccess();
                    break;
                }
                case MESSAGE: {
                    if (packet.hasFlags((short)1)) {
                        ctx.writeAndFlush((Object)new BusPacket(BusPacketType.ACK, 0, packet.getPacketId()));
                    }
                    this.wrappedListener.onMessage(this.bus, packet.getMessage());
                    break;
                }
                default: {
                    ctx.close();
                    throw new IllegalStateException("Unexpected packet received: " + String.valueOf((Object)packet.getType()));
                }
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof BusOutgoingMessage) {
            BusOutgoingMessage outgoingMessage = (BusOutgoingMessage)msg;
            if (promise.isDone()) {
                return;
            }
            if (!ctx.channel().isActive()) {
                promise.tryFailure((Throwable)new ClosedChannelException());
                return;
            }
            GUID packetId = outgoingMessage.getPacketId();
            short flags = 0;
            BusDeliveryTracking level = outgoingMessage.getLevel();
            ChannelPromise writePromise = promise;
            switch (level) {
                case NONE: {
                    writePromise = ctx.newPromise();
                    break;
                }
                case FULL: {
                    writePromise = ctx.newPromise();
                    flags = (short)(flags | 1);
                    this.deliveryQueue.add(new DeliveryEntry(packetId, promise));
                    break;
                }
            }
            BusPacket packet = new BusPacket(BusPacketType.MESSAGE, flags, packetId, outgoingMessage.getMessage());
            ctx.write((Object)packet, writePromise);
            if (level == BusDeliveryTracking.NONE) {
                promise.trySuccess();
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private static class DeliveryEntry {
        private final GUID packetId;
        private final ChannelPromise promise;

        DeliveryEntry(GUID packetId, ChannelPromise promise) {
            this.packetId = packetId;
            this.promise = promise;
        }

        public GUID getPacketId() {
            return this.packetId;
        }

        public ChannelPromise getPromise() {
            return this.promise;
        }
    }
}

