/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.bus.Bus;
import tech.ytsaurus.client.bus.BusDeliveryTracking;
import tech.ytsaurus.client.bus.BusLifecycle;
import tech.ytsaurus.client.bus.BusOutgoingMessage;
import tech.ytsaurus.client.bus.BusUtil;
import tech.ytsaurus.client.bus.DefaultBusChannelMetricsHolder;
import tech.ytsaurus.client.bus.DefaultBusChannelMetricsHolderImpl;
import tech.ytsaurus.core.GUID;

public class DefaultBusChannel
implements Bus,
BusLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBusChannel.class);
    private static final AttributeKey<DefaultBusChannel> CHANNEL_KEY = AttributeKey.valueOf((String)DefaultBusChannel.class.getName());
    private final Channel channel;
    private final ChannelPromise connected;
    private final ChannelPromise disconnected;
    private final DefaultBusChannelMetricsHolder metricsHolder;

    public DefaultBusChannel(Channel channel) {
        this(channel, new DefaultBusChannelMetricsHolderImpl());
    }

    public DefaultBusChannel(Channel channel, DefaultBusChannelMetricsHolder metricsHolder) {
        this.channel = Objects.requireNonNull(channel);
        this.connected = channel.newPromise();
        this.connected.setUncancellable();
        this.disconnected = channel.newPromise();
        this.disconnected.setUncancellable();
        this.metricsHolder = metricsHolder;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public EventLoop eventLoop() {
        return this.channel.eventLoop();
    }

    @Override
    public ChannelFuture connected() {
        return this.connected;
    }

    @Override
    public ChannelFuture disconnected() {
        return this.disconnected;
    }

    @Override
    public ChannelFuture closed() {
        return this.channel.closeFuture();
    }

    @Override
    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public CompletableFuture<Void> close() {
        return BusUtil.makeCompletableFuture(this.channel.close());
    }

    @Override
    public CompletableFuture<Void> send(List<byte[]> message, BusDeliveryTracking level) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        BusOutgoingMessage outgoingMessage = new BusOutgoingMessage(message, level);
        if (this.connected.isDone()) {
            this.sendNow(outgoingMessage, result);
        } else {
            this.connected.addListener(ignored -> {
                if (!result.isDone()) {
                    this.sendNow(outgoingMessage, result);
                }
            });
        }
        return result;
    }

    private void logWriteResult(GUID packetId, Instant started) {
        long elapsed = Duration.between(started, Instant.now()).toMillis();
        logger.trace("(DefaultBusChannel({}@{})) message `{}` sent in {} ms", new Object[]{this.channel.remoteAddress(), this.hashCode(), packetId, elapsed});
        this.metricsHolder.updatePacketsHistogram(elapsed);
    }

    private void sendNow(BusOutgoingMessage outgoingMessage, CompletableFuture<Void> result) {
        if (this.connected.cause() != null) {
            logger.trace("(DefaultBusChannel({}@{})) cannot send message `{}`: `{}`", new Object[]{this.channel.remoteAddress(), this.hashCode(), outgoingMessage.getPacketId(), this.connected.cause()});
            result.completeExceptionally(this.connected.cause());
        } else {
            Instant started = Instant.now();
            GUID packetId = outgoingMessage.getPacketId();
            logger.trace("(DefaultBusChannel({}@{})) sending message `{}`", new Object[]{this.channel.remoteAddress(), this.hashCode(), packetId});
            ChannelFuture writeResult = this.channel.writeAndFlush((Object)outgoingMessage);
            if (writeResult.isDone()) {
                this.logWriteResult(packetId, started);
            } else {
                writeResult.addListener(unused -> this.logWriteResult(packetId, started));
            }
            BusUtil.relayResult(writeResult, result);
            BusUtil.relayCancel(result, writeResult);
        }
    }

    @Override
    public void channelConnected() {
        this.connected.trySuccess();
    }

    @Override
    public void channelDisconnected() {
        this.disconnected.trySuccess();
    }

    @Override
    public void channelFailed(Throwable cause) {
        this.connected.tryFailure(cause);
        this.disconnected.tryFailure(cause);
    }

    public static DefaultBusChannel getOrCreateInstance(Channel channel, DefaultBusChannelMetricsHolder metricsHolder) {
        DefaultBusChannel old;
        Attribute attr = channel.attr(CHANNEL_KEY);
        DefaultBusChannel bus = (DefaultBusChannel)attr.get();
        if (bus == null && (old = (DefaultBusChannel)attr.setIfAbsent((Object)(bus = new DefaultBusChannel(channel, metricsHolder)))) != null) {
            bus = old;
        }
        return bus;
    }

    public static DefaultBusChannel getOrCreateInstance(Channel channel) {
        return DefaultBusChannel.getOrCreateInstance(channel, DefaultBusChannelMetricsHolderImpl.INSTANCE);
    }
}

