/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import tech.ytsaurus.client.bus.Bus;
import tech.ytsaurus.client.bus.BusConnector;
import tech.ytsaurus.client.bus.BusListener;
import tech.ytsaurus.client.bus.BusServer;
import tech.ytsaurus.client.bus.DefaultBusChannel;
import tech.ytsaurus.client.bus.DefaultBusChannelMetricsHolder;
import tech.ytsaurus.client.bus.DefaultBusChannelMetricsHolderImpl;
import tech.ytsaurus.client.bus.DefaultBusInitializer;
import tech.ytsaurus.client.bus.DefaultBusServerChannel;

public class DefaultBusConnector
implements BusConnector {
    private final EventLoopGroup group;
    private final boolean groupOwner;
    private Duration readTimeout = Duration.ofMinutes(2L);
    private Duration writeTimeout = Duration.ofMinutes(2L);
    private boolean verifyChecksums = false;
    private boolean calculateChecksums = false;
    private DefaultBusChannelMetricsHolder metricsHolder;

    public DefaultBusConnector() {
        this((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory(DefaultBusConnector.class, true, 5)), true);
    }

    public DefaultBusConnector(EventLoopGroup group) {
        this(group, false);
    }

    public DefaultBusConnector(EventLoopGroup group, boolean groupOwner) {
        this(group, groupOwner, new DefaultBusChannelMetricsHolderImpl());
    }

    public DefaultBusConnector(EventLoopGroup group, boolean groupOwner, DefaultBusChannelMetricsHolder metricsHolder) {
        this.group = Objects.requireNonNull(group);
        this.groupOwner = groupOwner;
        this.metricsHolder = metricsHolder;
    }

    public EventLoopGroup getGroup() {
        return this.group;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public boolean isVerifyChecksums() {
        return this.verifyChecksums;
    }

    public boolean isCalculateChecksums() {
        return this.calculateChecksums;
    }

    public DefaultBusConnector setReadTimeout(Duration readTimeout) {
        this.readTimeout = Objects.requireNonNull(readTimeout);
        return this;
    }

    public DefaultBusConnector setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = Objects.requireNonNull(writeTimeout);
        return this;
    }

    public DefaultBusConnector setVerifyChecksums(boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
        return this;
    }

    public DefaultBusConnector setCalculateChecksums(boolean calculateChecksums) {
        this.calculateChecksums = calculateChecksums;
        return this;
    }

    private Bootstrap newInetBootstrap(BusListener listener) {
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new DefaultBusInitializer(listener, this.metricsHolder).setReadTimeout(this.readTimeout).setWriteTimeout(this.writeTimeout).setVerifyChecksums(this.verifyChecksums).setCalculateChecksums(this.calculateChecksums));
    }

    private Bootstrap newSocketBootstrap(BusListener listener) {
        return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(EpollDomainSocketChannel.class)).handler((ChannelHandler)new DefaultBusInitializer(listener, this.metricsHolder).setReadTimeout(this.readTimeout).setWriteTimeout(this.writeTimeout).setVerifyChecksums(this.verifyChecksums).setCalculateChecksums(this.calculateChecksums));
    }

    @Override
    public Bus connect(SocketAddress address, BusListener listener) {
        ChannelFuture f;
        if (address instanceof InetSocketAddress) {
            f = this.newInetBootstrap(listener).connect(address);
        } else if (address instanceof DomainSocketAddress) {
            f = this.newSocketBootstrap(listener).connect(address);
        } else {
            throw new UnsupportedAddressTypeException();
        }
        try {
            DefaultBusChannel bus = DefaultBusChannel.getOrCreateInstance(f.channel(), this.metricsHolder);
            f.addListener(ready -> {
                if (ready.isSuccess()) {
                    bus.channelConnected();
                } else {
                    try {
                        bus.channelFailed(ready.cause());
                    }
                    finally {
                        bus.close();
                    }
                }
            });
            return bus;
        }
        catch (Throwable e) {
            f.cancel(false);
            throw e;
        }
    }

    private ServerBootstrap newServerBootstrap(BusListener listener) {
        return ((ServerBootstrap)new ServerBootstrap().group(this.group).channel(NioServerSocketChannel.class)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new DefaultBusInitializer(listener, this.metricsHolder).setReadTimeout(this.readTimeout).setWriteTimeout(this.writeTimeout));
    }

    @Override
    public BusServer listen(SocketAddress address, BusListener listener) {
        ChannelFuture f = this.newServerBootstrap(listener).bind(address);
        try {
            DefaultBusServerChannel server = new DefaultBusServerChannel((ServerChannel)f.channel());
            f.addListener(ready -> {
                if (ready.isSuccess()) {
                    server.listenSucceeded();
                } else {
                    try {
                        server.listenFailed(ready.cause());
                    }
                    finally {
                        server.close();
                    }
                }
            });
            return server;
        }
        catch (Throwable e) {
            f.cancel(false);
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.groupOwner) {
            this.group.shutdownGracefully(0L, 500L, TimeUnit.MILLISECONDS).syncUninterruptibly();
        }
    }

    @Override
    public EventLoopGroup eventLoopGroup() {
        return this.group;
    }
}

