/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.discovery;

import java.util.List;
import java.util.stream.Collectors;
import tech.ytsaurus.client.discovery.Discoverer;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeTextSerializer;

public class StaticDiscoverer
implements Discoverer {
    private static final String ENV_NAME = "YT_DISCOVERY_ADDRESSES";
    private final List<String> addresses;

    public StaticDiscoverer(List<String> addresses) {
        this.addresses = List.copyOf(addresses);
    }

    public StaticDiscoverer(YTreeNode node) {
        this(node.asList().stream().map(YTreeNode::stringValue).collect(Collectors.toList()));
    }

    public static StaticDiscoverer loadFromEnvironment() {
        String rawList = System.getenv(ENV_NAME);
        if (rawList == null || rawList.isEmpty()) {
            throw new IllegalStateException(String.format("Environment variable %s is not found", ENV_NAME));
        }
        return new StaticDiscoverer(YTreeTextSerializer.deserialize((String)rawList));
    }

    @Override
    public List<String> listDiscoveryServers() {
        return this.addresses;
    }

    @Override
    public void stop() {
    }
}

