/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.misc;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import tech.ytsaurus.client.misc.SerializedExecutorService;

public class ScheduledSerializedExecutorService
extends SerializedExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService underlying;

    public ScheduledSerializedExecutorService(@Nonnull ScheduledExecutorService underlying) {
        super(underlying);
        this.underlying = underlying;
    }

    @Override
    @Nonnull
    public ScheduledFuture<?> schedule(@Nonnull Runnable runnable, long l, @Nonnull TimeUnit timeUnit) {
        CompletableFuture completable = new CompletableFuture();
        ScheduledFuture<?> scheduled = this.underlying.schedule(() -> ((CompletableFuture)super.submit(runnable)).handle((v, t) -> {
            if (t != null) {
                completable.completeExceptionally((Throwable)t);
            } else {
                completable.complete(null);
            }
            return null;
        }), l, timeUnit);
        return this.toScheduledFuture(scheduled, completable);
    }

    @Override
    @Nonnull
    public <V> ScheduledFuture<V> schedule(@Nonnull Callable<V> callable, long l, @Nonnull TimeUnit timeUnit) {
        CompletableFuture completable = new CompletableFuture();
        ScheduledFuture<Void> scheduled = this.underlying.schedule(() -> {
            ((CompletableFuture)super.submit(callable)).handle((v, t) -> {
                if (t != null) {
                    completable.completeExceptionally((Throwable)t);
                } else {
                    completable.complete(v);
                }
                return null;
            });
            return null;
        }, l, timeUnit);
        return this.toScheduledFuture(scheduled, completable);
    }

    @Override
    @Nonnull
    public ScheduledFuture<?> scheduleAtFixedRate(@Nonnull Runnable runnable, long l, long l1, @Nonnull TimeUnit timeUnit) {
        return this.underlying.scheduleAtFixedRate(() -> this.execute(runnable), l, l1, timeUnit);
    }

    @Override
    @Nonnull
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nonnull Runnable runnable, long l, long l1, @Nonnull TimeUnit timeUnit) {
        return this.underlying.scheduleWithFixedDelay(() -> this.execute(runnable), l, l1, timeUnit);
    }

    private <V> ScheduledFuture<V> toScheduledFuture(final ScheduledFuture<?> scheduled, final CompletableFuture<V> completable) {
        return new ScheduledFuture<V>(){

            @Override
            public long getDelay(@Nonnull TimeUnit timeUnit) {
                return scheduled.getDelay(timeUnit);
            }

            @Override
            public int compareTo(@Nonnull Delayed delayed) {
                return scheduled.compareTo(delayed);
            }

            @Override
            public boolean cancel(boolean b) {
                scheduled.cancel(b);
                return completable.cancel(b);
            }

            @Override
            public boolean isCancelled() {
                return completable.isCancelled();
            }

            @Override
            public boolean isDone() {
                return completable.isDone();
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                return completable.get();
            }

            @Override
            public V get(long l, @Nonnull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return completable.get(l, timeUnit);
            }
        };
    }
}

