/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.misc;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public class SerializedExecutorService
implements ExecutorService {
    private final ExecutorService underlying;
    private final AtomicBoolean lock = new AtomicBoolean();
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();

    public SerializedExecutorService(@Nonnull ExecutorService underlying) {
        this.underlying = underlying;
    }

    @Override
    public void shutdown() {
        this.underlying.shutdown();
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        List<Runnable> result = this.underlying.shutdownNow();
        result.addAll(this.taskQueue);
        return result;
    }

    @Override
    public boolean isShutdown() {
        return this.underlying.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.underlying.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        return this.underlying.awaitTermination(l, timeUnit);
    }

    @Nonnull
    public <T> CompletableFuture<T> submit(@Nonnull Callable<T> callable) {
        CompletableFuture result = new CompletableFuture();
        this.execute(() -> {
            if (!result.isDone()) {
                try {
                    result.complete(callable.call());
                }
                catch (Throwable exception) {
                    result.completeExceptionally(exception);
                }
            }
        });
        return result;
    }

    @Nonnull
    public <T> CompletableFuture<T> submit(@Nonnull Runnable runnable, T t) {
        return this.submit(() -> {
            runnable.run();
            return t;
        });
    }

    @Nonnull
    public CompletableFuture<Void> submit(@Nonnull Runnable runnable) {
        return this.submit(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> collection) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> collection, long l, @Nonnull TimeUnit timeUnit) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> collection) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> collection, long l, @Nonnull TimeUnit timeUnit) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        this.taskQueue.add(runnable);
        this.trySchedule();
    }

    private void trySchedule() {
        if (this.lock.compareAndSet(false, true)) {
            this.underlying.execute(() -> {
                Runnable r = this.taskQueue.poll();
                if (r != null) {
                    r.run();
                }
                this.lock.set(false);
                if (!this.taskQueue.isEmpty()) {
                    this.trySchedule();
                }
            });
        }
    }
}

