/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.UserJobSpec;
import tech.ytsaurus.client.operations.YTableEntryType;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.core.YtFormat;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeStringNode;

@NonNullFields
@NonNullApi
public class CommandSpec
implements Spec,
UserJobSpec {
    private final String command;
    private final YTreeStringNode inputFormat;
    private final YTreeStringNode outputFormat;
    private final List<YPath> files;
    @Nullable
    private final DataSize memoryLimit;
    private final boolean useTmpfs;
    @Nullable
    private final DataSize tmpfsSize;
    private final Map<String, String> environment;
    @Nullable
    private final Double cpuLimit;
    @Nullable
    private final Long jobTimeLimit;
    protected final List<YPath> outputTablePaths;
    @Nullable
    private final Integer jobCount;

    public CommandSpec(String command) {
        this((BuilderBase)CommandSpec.builder().setCommand(command));
    }

    protected <T extends BuilderBase<T>> CommandSpec(BuilderBase<T> builder) {
        if (builder.command == null) {
            throw new RuntimeException("command is not set");
        }
        this.command = builder.command;
        this.files = builder.files;
        this.memoryLimit = builder.memoryLimit;
        this.useTmpfs = builder.useTmpfs;
        this.tmpfsSize = builder.tmpfsSize;
        this.environment = builder.environment;
        this.cpuLimit = builder.cpuLimit;
        this.jobTimeLimit = builder.jobTimeLimit;
        this.jobCount = builder.jobCount;
        this.outputTablePaths = builder.outputTablePaths;
        FormatContext formatContext = FormatContext.builder().setOutputTableCount(this.outputTablePaths.size()).build();
        this.inputFormat = builder.inputType != null ? builder.inputType.format(formatContext) : builder.inputFormat;
        this.outputFormat = builder.outputType != null ? builder.outputType.format(formatContext) : builder.outputFormat;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandSpec spec = (CommandSpec)obj;
        return this.command.equals(spec.command) && this.inputFormat.equals(spec.inputFormat) && this.outputFormat.equals(spec.outputFormat) && this.files.equals(spec.files) && Optional.ofNullable(this.memoryLimit).equals(Optional.ofNullable(spec.memoryLimit)) && this.useTmpfs == spec.useTmpfs && Optional.ofNullable(this.tmpfsSize).equals(Optional.ofNullable(spec.tmpfsSize)) && this.environment.equals(spec.environment) && Optional.ofNullable(this.cpuLimit).equals(Optional.ofNullable(spec.cpuLimit)) && Optional.ofNullable(this.jobTimeLimit).equals(Optional.ofNullable(spec.jobTimeLimit)) && this.outputTablePaths.equals(spec.outputTablePaths) && Optional.ofNullable(this.jobCount).equals(Optional.ofNullable(spec.jobCount));
    }

    public String getCommand() {
        return this.command;
    }

    public YTreeStringNode getInputFormat() {
        return this.inputFormat;
    }

    public YTreeStringNode getOutputFormat() {
        return this.outputFormat;
    }

    public List<YPath> getFiles() {
        return this.files;
    }

    public Optional<DataSize> getMemoryLimit() {
        return Optional.ofNullable(this.memoryLimit);
    }

    public boolean isUseTmpfs() {
        return this.useTmpfs;
    }

    public Optional<DataSize> getTmpfsSize() {
        return Optional.ofNullable(this.tmpfsSize);
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public Optional<Double> getCpuLimit() {
        return Optional.ofNullable(this.cpuLimit);
    }

    public Optional<Long> getJobTimeLimit() {
        return Optional.ofNullable(this.jobTimeLimit);
    }

    public Optional<Integer> getJobCount() {
        return Optional.ofNullable(this.jobCount);
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        return builder.beginMap().key("command").value(this.command).key("input_format").value((YTreeNode)this.inputFormat).key("output_format").value((YTreeNode)this.outputFormat).when(!this.files.isEmpty(), b -> b.key("file_paths").value(this.files, (b2, t) -> t.toTree(b2))).when(this.memoryLimit != null, b -> b.key("memory_limit").value(this.memoryLimit.toBytes())).when(this.useTmpfs, b -> b.key("tmpfs_path").value(".").key("copy_files").value(true)).when(this.tmpfsSize != null, b -> b.key("tmpfs_size").value(this.tmpfsSize.toBytes())).key("environment").value(this.environment).when(this.cpuLimit != null, b -> b.key("cpu_limit").value(this.cpuLimit)).when(this.jobTimeLimit != null, b -> b.key("job_time_limit").value(this.jobTimeLimit)).when(this.jobCount != null, b -> b.key("job_count").value(this.jobCount)).when(!this.outputTablePaths.isEmpty(), b -> b.key("output_table_paths").value((Collection)this.outputTablePaths.stream().map(YPath::toTree).collect(Collectors.toList()))).endMap();
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext, FormatContext formatContext) {
        return this.prepare(builder, yt, specPreparationContext);
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    @NonNullFields
    @NonNullApi
    public static abstract class BuilderBase<T extends BuilderBase<T>> {
        @Nullable
        String command = null;
        YTreeStringNode inputFormat = YtFormat.YSON_BINARY;
        YTreeStringNode outputFormat = YtFormat.YSON_BINARY;
        @Nullable
        YTableEntryType<?> inputType;
        @Nullable
        YTableEntryType<?> outputType;
        List<YPath> files = new ArrayList<YPath>();
        @Nullable
        DataSize memoryLimit = null;
        boolean useTmpfs = false;
        @Nullable
        DataSize tmpfsSize = null;
        Map<String, String> environment = new HashMap<String, String>();
        @Nullable
        Double cpuLimit = null;
        @Nullable
        Long jobTimeLimit = null;
        @Nullable
        Integer jobCount = null;
        List<YPath> outputTablePaths = new ArrayList<YPath>();

        public CommandSpec build() {
            return new CommandSpec(this);
        }

        public T setCommand(String command) {
            this.command = command;
            return this.self();
        }

        public T setInputFormat(YTreeStringNode inputFormat) {
            this.inputFormat = inputFormat;
            return this.self();
        }

        public T setOutputFormat(YTreeStringNode outputFormat) {
            this.outputFormat = outputFormat;
            return this.self();
        }

        public T setInputType(@Nullable YTableEntryType<?> inputType) {
            this.inputType = inputType;
            return this.self();
        }

        public T setOutputType(@Nullable YTableEntryType<?> outputType) {
            this.outputType = outputType;
            return this.self();
        }

        public T setFiles(List<YPath> files) {
            this.files = files;
            return this.self();
        }

        public T setMemoryLimit(@Nullable DataSize memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this.self();
        }

        public T setUseTmpfs(boolean useTmpfs) {
            this.useTmpfs = useTmpfs;
            return this.self();
        }

        public T setTmpfsSize(@Nullable DataSize tmpfsSize) {
            this.tmpfsSize = tmpfsSize;
            return this.self();
        }

        public T setEnvironment(Map<String, String> environment) {
            this.environment = environment;
            return this.self();
        }

        public T setCpuLimit(@Nullable Double cpuLimit) {
            this.cpuLimit = cpuLimit;
            return this.self();
        }

        public T setJobTimeLimit(@Nullable Long jobTimeLimit) {
            this.jobTimeLimit = jobTimeLimit;
            return this.self();
        }

        public T setJobCount(@Nullable Integer jobCount) {
            this.jobCount = jobCount;
            return this.self();
        }

        public T setOutputTablePaths(List<YPath> outputTablePaths) {
            this.outputTablePaths = outputTablePaths;
            return this.self();
        }

        protected abstract T self();
    }

    protected static class Builder
    extends BuilderBase<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

