/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.List;
import javax.annotation.Nullable;
import tech.ytsaurus.core.JavaOptions;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class JavaYtRunner {
    protected JavaYtRunner() {
    }

    public static String normalizeClassName(String clazz) {
        return clazz.replace("$", "dollar_char");
    }

    public static String denormalizeClassName(String name) {
        return name.replace("dollar_char", "$");
    }

    public static String command(String javaBinary, String classPath, @Nullable String libraryPath, JavaOptions javaOptions, String mainClazz, List<String> args) {
        String javaPath = "-cp " + classPath;
        if (libraryPath != null) {
            javaPath = javaPath + " -Djava.library.path=" + libraryPath;
        }
        return javaBinary + " " + String.join((CharSequence)" ", javaOptions.getOptions()) + " " + javaPath + " " + JavaYtRunner.normalizeClassName(mainClazz) + (String)(args.isEmpty() ? "" : " " + String.join((CharSequence)" ", args));
    }
}

