/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.FileWriter;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.JavaYtRunner;
import tech.ytsaurus.client.operations.JobIo;
import tech.ytsaurus.client.operations.MapperOrReducer;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.UserJobSpec;
import tech.ytsaurus.client.request.CreateNode;
import tech.ytsaurus.client.request.WriteFile;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.JavaOptions;
import tech.ytsaurus.core.cypress.CypressNodeType;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public abstract class MapperOrReducerSpec
implements UserJobSpec {
    public static final DataSize DEFAULT_MEMORY_LIMIT = DataSize.fromMegaBytes((long)512L);
    public static final JavaOptions DEFAULT_JAVA_OPTIONS = JavaOptions.empty().withXmx(DEFAULT_MEMORY_LIMIT);
    private static final Logger logger = LoggerFactory.getLogger(MapperOrReducerSpec.class);
    protected final Class<?> mainClazz;
    protected final MapperOrReducer<?, ?> mapperOrReducer;
    protected final Set<YPath> additionalFiles;
    protected final JavaOptions javaOptions;
    protected final DataSize memoryLimit;
    protected final boolean useTmpfs;
    @Nullable
    protected final DataSize tmpfsSize;
    @Nullable
    protected final Double cpuLimit;
    @Nullable
    protected final Long jobTimeLimit;
    @Nullable
    protected final Integer jobCount;
    protected final Map<String, String> environment;
    protected final List<YPath> layerPaths;
    @Nullable
    protected final String operationBaseLayer;
    @Nullable
    protected final Integer customStatisticsCountLimit;
    @Nullable
    protected final Double memoryReserveFactor;
    @Nullable
    protected final String networkProject;
    @Nullable
    protected final Duration prepareTimeLimit;

    protected MapperOrReducerSpec(Class<?> mainClazz, Builder<?> builder) {
        if (builder.userJob == null) {
            throw new RuntimeException("userJob wasn't set");
        }
        this.mainClazz = mainClazz;
        this.mapperOrReducer = builder.userJob;
        this.additionalFiles = builder.additionalFiles;
        this.javaOptions = builder.javaOptions;
        this.memoryLimit = builder.memoryLimit;
        this.useTmpfs = builder.useTmpfs;
        this.tmpfsSize = builder.tmpfsSize;
        this.cpuLimit = builder.cpuLimit;
        this.jobTimeLimit = builder.jobTimeLimit;
        this.jobCount = builder.jobCount;
        this.environment = builder.environment;
        this.layerPaths = builder.layerPaths;
        this.operationBaseLayer = builder.operationBaseLayer;
        this.customStatisticsCountLimit = builder.customStatisticsCountLimit;
        this.memoryReserveFactor = builder.memoryReserveFactor;
        this.networkProject = builder.networkProject;
        this.prepareTimeLimit = builder.prepareTimeLimit;
    }

    public String getMapperOrReducerTitle() {
        return this.mapperOrReducer.getClass().getName();
    }

    private boolean trackIndices() {
        return this.mapperOrReducer.trackIndices();
    }

    JobIo createJobIo(@Nullable JobIo jobIo) {
        JobIo jobIo2 = jobIo = jobIo == null ? new JobIo() : jobIo;
        if (!this.trackIndices()) {
            return jobIo;
        }
        return ((JobIo.BuilderBase)((JobIo.BuilderBase)jobIo.toBuilder().setEnableRowIndex(true)).setEnableTableIndex(true)).build();
    }

    protected Optional<Resource> detectResourcesUnsafe(TransactionalClient yt, MapperOrReducer<?, ?> mapperOrReducer, SpecPreparationContext context) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (mapperOrReducer instanceof Serializable) {
            String fileName = String.valueOf(GUID.create()) + ".serializable";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(mapperOrReducer);
            oos.close();
            byte[] bytes = baos.toByteArray();
            args.add("serializable");
            YPath path = context.getConfiguration().getTmpDir().child(fileName);
            yt.createNode(((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setType(CypressNodeType.FILE)).setPath(path)).build()).join();
            FileWriter writer = yt.writeFile(new WriteFile(path.toString())).join();
            writer.write(bytes);
            writer.readyEvent().join();
            writer.close().join();
            args.add(fileName);
            return Optional.of(new Resource(path.plusAdditionalAttribute("file_name", (Object)fileName), args));
        }
        return Optional.empty();
    }

    private Optional<Resource> detectResources(TransactionalClient yt, MapperOrReducer<?, ?> mapperOrReducer, SpecPreparationContext context) {
        try {
            return this.detectResourcesUnsafe(yt, mapperOrReducer, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String canonizeJavaPath(String javaPath) {
        String[] pathParts = javaPath.split(":");
        ArrayList<String> canonicalPathParts = new ArrayList<String>(pathParts.length);
        for (String path : pathParts) {
            try {
                canonicalPathParts.add(new File(path).getCanonicalPath());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return String.join((CharSequence)":", canonicalPathParts);
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext, FormatContext formatContext) {
        String classPath;
        HashSet<YPath> files = new HashSet<YPath>(this.additionalFiles);
        boolean isLocalMode = specPreparationContext.getConfiguration().isLocalMode();
        String libraryPath = null;
        if (isLocalMode) {
            classPath = this.canonizeJavaPath(System.getProperty("java.class.path"));
            libraryPath = this.canonizeJavaPath(System.getProperty("java.library.path"));
        } else {
            Set<YPath> jars = specPreparationContext.getConfiguration().getJarsProcessor().uploadJars(yt.getRootClient(), this.mapperOrReducer, isLocalMode);
            files.addAll(jars);
            List jarFileNames = jars.stream().map(x -> x.getAdditionalAttribute("file_name").map(YTreeNode::stringValue).orElseGet(() -> ((YPath)x).name())).collect(Collectors.toList());
            classPath = String.join((CharSequence)":", jarFileNames);
        }
        Set<YPath> autoDetectedResources = specPreparationContext.getConfiguration().getJarsProcessor().uploadResources(yt.getRootClient(), this.mapperOrReducer);
        files.addAll(autoDetectedResources);
        Optional<Resource> resource = this.detectResources(yt, this.mapperOrReducer, specPreparationContext);
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.valueOf(formatContext.getOutputTableCount().orElseThrow(IllegalArgumentException::new)));
        if (resource.isEmpty()) {
            args.add("simple");
            args.add(JavaYtRunner.normalizeClassName(this.mapperOrReducer.getClass().getName()));
        } else {
            args.addAll(resource.get().args);
            files.add(resource.get().path);
        }
        String javaBinary = specPreparationContext.getConfiguration().getJavaBinary();
        JavaOptions resultJavaOptions = JavaOptions.empty();
        for (String option : specPreparationContext.getConfiguration().getJavaOptions()) {
            resultJavaOptions = resultJavaOptions.withOption(option);
        }
        for (String option : this.javaOptions.getOptions()) {
            resultJavaOptions = resultJavaOptions.withOption(option);
        }
        YTreeBuilder specBuilder = builder.beginMap();
        this.setLayerPaths(specBuilder, specPreparationContext);
        return specBuilder.key("command").value(JavaYtRunner.command(javaBinary, classPath, libraryPath, resultJavaOptions, this.mainClazz.getName(), args)).key("input_format").value((YTreeNode)this.mapperOrReducer.inputType().format(formatContext)).key("output_format").value((YTreeNode)this.mapperOrReducer.outputType().format(formatContext)).key("file_paths").value(files, (b, t) -> b.apply(arg_0 -> ((YPath)t).toTree(arg_0))).key("memory_limit").value(this.memoryLimit.toBytes()).when(this.memoryReserveFactor != null, b -> b.key("memory_reserve_factor").value(this.memoryReserveFactor)).when(this.useTmpfs, b -> b.key("tmpfs_path").value(".").key("copy_files").value(true)).when(this.tmpfsSize != null, b -> b.key("tmpfs_size").value(Objects.requireNonNull(this.tmpfsSize).toBytes())).when(this.cpuLimit != null, b -> b.key("cpu_limit").value(this.cpuLimit)).when(this.jobTimeLimit != null, b -> b.key("job_time_limit").value(this.jobTimeLimit)).when(this.jobCount != null, b -> b.key("job_count").value(this.jobCount)).key("environment").value(this.environment).when(this.customStatisticsCountLimit != null, b -> b.key("custom_statistics_count_limit").value(this.customStatisticsCountLimit)).when(this.networkProject != null, b -> b.key("network_project").value(this.networkProject)).when(this.prepareTimeLimit != null, b -> b.key("prepare_time_limit").value(Objects.requireNonNull(this.prepareTimeLimit).toMillis())).when(formatContext.getOutputStreams().isPresent(), b -> b.key("output_streams").value(formatContext.getOutputStreams().get())).endMap();
    }

    private void setLayerPaths(YTreeBuilder specBuilder, SpecPreparationContext specPreparationContext) {
        List<YPath> resultLayerPaths = !specPreparationContext.getConfiguration().getLayerPaths().isEmpty() ? specPreparationContext.getConfiguration().getLayerPaths() : this.layerPaths;
        boolean isLayersSpecified = false;
        if (!resultLayerPaths.isEmpty()) {
            isLayersSpecified = true;
            specBuilder.key("layer_paths").value((Collection)resultLayerPaths.stream().map(YPath::toTree).collect(Collectors.toList()));
        }
        this.guessBaseLayers(specBuilder, isLayersSpecified);
    }

    private void guessBaseLayers(YTreeBuilder specBuilder, boolean isLayersSpecified) {
        String userLayer = this.operationBaseLayer;
        String userLayerEnv = System.getenv("YT_BASE_LAYER");
        if (userLayerEnv != null) {
            userLayer = userLayerEnv;
        }
        if (userLayer == null) {
            return;
        }
        userLayer = userLayer.toLowerCase().strip();
        if (isLayersSpecified) {
            if (Arrays.asList("auto", "porto:auto", "docker:auto").contains(userLayer)) {
                logger.debug("Operation has layer spec. Do not guess base layer");
            }
            return;
        }
        if (List.of("auto", "docker:auto", "porto:auto").contains(userLayer)) {
            logger.warn("User layer '{}' is currently not supported", (Object)userLayer);
            return;
        }
        if (userLayer.startsWith("//")) {
            YTreeBuilder layerPathsBuilder = YTree.listBuilder();
            for (String path : userLayer.split(",")) {
                layerPathsBuilder.value(path.strip());
            }
            specBuilder.key("layer_paths").value((YTreeNode)layerPathsBuilder.buildList());
        } else if (userLayer.startsWith("registry.")) {
            String path = URI.create("//" + userLayer).getPath();
            if (path != null) {
                specBuilder.key("docker_image").value((YTreeNode)YTree.stringNode((String)path.substring(1)));
            }
        } else {
            specBuilder.key("docker_image").value((YTreeNode)YTree.stringNode((String)userLayer));
        }
    }

    @NonNullApi
    @NonNullFields
    public static abstract class Builder<T extends Builder<T>> {
        @Nullable
        MapperOrReducer<?, ?> userJob = null;
        Set<YPath> additionalFiles = Collections.emptySet();
        JavaOptions javaOptions = DEFAULT_JAVA_OPTIONS;
        DataSize memoryLimit = DEFAULT_MEMORY_LIMIT;
        boolean useTmpfs = false;
        @Nullable
        DataSize tmpfsSize = null;
        @Nullable
        Double cpuLimit = null;
        @Nullable
        Long jobTimeLimit = null;
        @Nullable
        Integer jobCount = null;
        Map<String, String> environment = new HashMap<String, String>();
        List<YPath> layerPaths = new ArrayList<YPath>();
        @Nullable
        String operationBaseLayer;
        @Nullable
        Integer customStatisticsCountLimit = null;
        @Nullable
        Double memoryReserveFactor = null;
        @Nullable
        String networkProject = null;
        @Nullable
        Duration prepareTimeLimit = null;

        public abstract MapperOrReducerSpec build();

        protected abstract T self();

        protected T setUserJob(MapperOrReducer<?, ?> userJob) {
            this.userJob = userJob;
            return this.self();
        }

        @Nullable
        protected MapperOrReducer<?, ?> getUserJob() {
            return this.userJob;
        }

        public T setAdditionalFiles(Set<YPath> additionalFiles) {
            this.additionalFiles = additionalFiles;
            return this.self();
        }

        public T setJavaOptions(JavaOptions javaOptions) {
            this.javaOptions = javaOptions;
            return this.self();
        }

        public T setMemoryLimit(DataSize memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this.self();
        }

        public T setUseTmpfs(boolean useTmpfs) {
            this.useTmpfs = useTmpfs;
            return this.self();
        }

        public T setTmpfsSize(@Nullable DataSize tmpfsSize) {
            this.tmpfsSize = tmpfsSize;
            return this.self();
        }

        public T setCpuLimit(@Nullable Double cpuLimit) {
            this.cpuLimit = cpuLimit;
            return this.self();
        }

        public T setJobTimeLimit(@Nullable Long jobTimeLimit) {
            this.jobTimeLimit = jobTimeLimit;
            return this.self();
        }

        public T setJobCount(@Nullable Integer jobCount) {
            this.jobCount = jobCount;
            return this.self();
        }

        public T setEnvironment(Map<String, String> environment) {
            this.environment = environment;
            return this.self();
        }

        public T setLayerPaths(List<YPath> layerPaths) {
            this.layerPaths = layerPaths;
            return this.self();
        }

        public T setOperationBaseLayer(String baseLayer) {
            this.operationBaseLayer = baseLayer;
            return this.self();
        }

        public T setCustomStatisticsCountLimit(@Nullable Integer customStatisticsCountLimit) {
            this.customStatisticsCountLimit = customStatisticsCountLimit;
            return this.self();
        }

        public T setMemoryReserveFactor(@Nullable Double memoryReserveFactor) {
            this.memoryReserveFactor = memoryReserveFactor;
            return this.self();
        }

        public T setNetworkProject(@Nullable String networkProject) {
            this.networkProject = networkProject;
            return this.self();
        }

        public T setPrepareTimeLimit(@Nullable Duration prepareTimeLimit) {
            this.prepareTimeLimit = prepareTimeLimit;
            return this.self();
        }
    }

    protected static class Resource {
        private final YPath path;
        private final List<String> args;

        public Resource(YPath path, List<String> args) {
            this.path = path;
            this.args = args;
        }
    }
}

