/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.JobIo;
import tech.ytsaurus.client.operations.MergeMode;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.client.operations.SystemOperationSpecBase;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class MergeSpec
extends SystemOperationSpecBase
implements Spec {
    @Nullable
    private final Integer jobCount;
    private final MergeMode mergeMode;
    private final boolean combineChunks;
    private final List<String> mergeBy;
    @Nullable
    private final DataSize dataSizePerJob;
    @Nullable
    private final DataSize maxDataSizePerJob;
    @Nullable
    private final JobIo jobIo;

    public MergeSpec(List<YPath> inputTables, YPath outputTable) {
        this((BuilderBase)((BuilderBase)MergeSpec.builder().setInputTables(inputTables)).setOutputTable(outputTable));
    }

    protected <T extends BuilderBase<T>> MergeSpec(BuilderBase<T> builder) {
        super(builder);
        this.jobCount = builder.jobCount;
        this.mergeMode = builder.mergeMode;
        this.combineChunks = builder.combineChunks;
        this.mergeBy = builder.mergeBy;
        this.dataSizePerJob = builder.dataSizePerJob;
        this.jobIo = builder.jobIo;
        this.maxDataSizePerJob = builder.maxDataSizePerJob;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeSpec spec = (MergeSpec)obj;
        return super.equals(obj) && Optional.ofNullable(this.jobCount).equals(Optional.ofNullable(spec.jobCount)) && this.mergeMode.equals((Object)spec.mergeMode) && this.combineChunks == spec.combineChunks && this.mergeBy.equals(spec.mergeBy) && Optional.ofNullable(this.dataSizePerJob).equals(Optional.ofNullable(spec.dataSizePerJob)) && Optional.ofNullable(this.jobIo).equals(Optional.ofNullable(spec.jobIo)) && Optional.ofNullable(this.maxDataSizePerJob).equals(Optional.ofNullable(spec.maxDataSizePerJob));
    }

    public Optional<Integer> getJobCount() {
        return Optional.ofNullable(this.jobCount);
    }

    public Optional<DataSize> getDataSizePerJob() {
        return Optional.ofNullable(this.dataSizePerJob);
    }

    public MergeMode getMergeMode() {
        return this.mergeMode;
    }

    public boolean isCombineChunks() {
        return this.combineChunks;
    }

    public List<String> getMergeBy() {
        return this.mergeBy;
    }

    public Optional<DataSize> getMaxDataSizePerJob() {
        return Optional.ofNullable(this.maxDataSizePerJob);
    }

    public Optional<JobIo> getJobIo() {
        return Optional.ofNullable(this.jobIo);
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        SpecUtils.createOutputTables(yt, specPreparationContext.getTransactionalOptions().orElse(null), List.of(this.getOutputTable()), this.getOutputTableAttributes());
        return builder.beginMap().when(this.jobCount != null, b -> b.key("job_count").value(this.jobCount)).key("mode").value(this.mergeMode.value()).key("combine_chunks").value(this.combineChunks).when(!this.mergeBy.isEmpty(), b -> b.key("merge_by").value(this.mergeBy)).when(this.dataSizePerJob != null, b -> b.key("data_size_per_job").value(Objects.requireNonNull(this.dataSizePerJob).toBytes())).when(this.maxDataSizePerJob != null, b -> b.key("max_data_size_per_job").value(Objects.requireNonNull(this.maxDataSizePerJob).toBytes())).when(this.jobIo != null, b -> b.key("job_io").value((YTreeNode)Objects.requireNonNull(this.jobIo).prepare())).apply(b -> this.toTree((YTreeBuilder)b, specPreparationContext)).endMap();
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>>
    extends SystemOperationSpecBase.Builder<T> {
        @Nullable
        private Integer jobCount;
        private MergeMode mergeMode = MergeMode.UNORDERED;
        private boolean combineChunks = false;
        private List<String> mergeBy = new ArrayList<String>();
        @Nullable
        private DataSize dataSizePerJob;
        @Nullable
        private JobIo jobIo;
        @Nullable
        private DataSize maxDataSizePerJob;

        public MergeSpec build() {
            return new MergeSpec(this);
        }

        public T setJobCount(@Nullable Integer jobCount) {
            this.jobCount = jobCount;
            return (T)((BuilderBase)this.self());
        }

        public T setDataSizePerJob(DataSize dataSizePerJob) {
            this.dataSizePerJob = dataSizePerJob;
            return (T)((BuilderBase)this.self());
        }

        public T setMergeMode(MergeMode mergeMode) {
            this.mergeMode = mergeMode;
            return (T)((BuilderBase)this.self());
        }

        public T setCombineChunks(boolean combineChunks) {
            this.combineChunks = combineChunks;
            return (T)((BuilderBase)this.self());
        }

        public T setMergeBy(Collection<String> mergeBy) {
            this.mergeBy = new ArrayList<String>(mergeBy);
            return (T)((BuilderBase)this.self());
        }

        public T setMergeBy(String ... mergeBy) {
            return this.setMergeBy(Arrays.asList(mergeBy));
        }

        public T setMaxDataSizePerJob(DataSize maxDataSizePerJob) {
            this.maxDataSizePerJob = maxDataSizePerJob;
            return (T)((BuilderBase)this.self());
        }

        public T setJobIo(JobIo jobIo) {
            this.jobIo = jobIo;
            return (T)((BuilderBase)this.self());
        }
    }

    protected static class Builder
    extends BuilderBase<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

