/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.operations.FailedJobInfo;
import tech.ytsaurus.client.operations.Operation;
import tech.ytsaurus.client.operations.OperationStatus;
import tech.ytsaurus.client.request.AbortOperation;
import tech.ytsaurus.client.request.CompleteOperation;
import tech.ytsaurus.client.request.GetJobStderr;
import tech.ytsaurus.client.request.GetOperation;
import tech.ytsaurus.client.request.JobResult;
import tech.ytsaurus.client.request.JobState;
import tech.ytsaurus.client.request.ListJobs;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeListNode;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class OperationImpl
implements Operation {
    private static final Logger logger = LoggerFactory.getLogger(OperationImpl.class);
    private final GUID id;
    private final ApiServiceClient client;
    private final ScheduledExecutorService executorService;
    private final Duration pingPeriod;
    private final CompletableFuture<Void> watchResult = new CompletableFuture();
    private Instant previousBriefProgressBuildTime;

    public OperationImpl(GUID id, ApiServiceClient client, ScheduledExecutorService executorService, Duration pingPeriod) {
        this.id = id;
        this.client = client;
        this.executorService = executorService;
        this.pingPeriod = pingPeriod;
        this.previousBriefProgressBuildTime = Instant.now();
    }

    @Override
    public GUID getId() {
        return this.id;
    }

    @Override
    public CompletableFuture<OperationStatus> getStatus() {
        return this.getOperation("state").thenApply(node -> (OperationStatus)OperationStatus.R.fromName(node.mapNode().getOrThrow("state").stringValue()));
    }

    @Override
    public CompletableFuture<YTreeNode> getResult() {
        return this.getOperation("result").thenApply(node -> node.mapNode().getOrThrow("result"));
    }

    @Override
    public CompletableFuture<Void> watch() {
        this.executorService.schedule(this::watchImpl, this.pingPeriod.toNanos(), TimeUnit.NANOSECONDS);
        return this.watchResult;
    }

    @Override
    public CompletableFuture<Void> watchAndThrowIfNotSuccess() {
        return ((CompletableFuture)this.watch().thenCompose(unused -> this.getStatus())).thenCompose(operationStatus -> {
            if (operationStatus.isSuccess()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getResult().thenAccept(operationResult -> {
                Map result;
                Map error = Collections.emptyMap();
                if (operationResult != null && (result = operationResult.asMap()).containsKey("error")) {
                    error = ((YTreeNode)result.get("error")).asMap();
                }
                throw YTsaurusError.parseFrom(error);
            });
        });
    }

    @Override
    public CompletableFuture<Void> abort() {
        return this.client.abortOperation(new AbortOperation(this.id));
    }

    @Override
    public CompletableFuture<Void> complete() {
        return this.client.completeOperation(new CompleteOperation(this.id));
    }

    private CompletableFuture<YTreeNode> getOperation(String attribute) {
        return this.client.getOperation(((GetOperation.Builder)((GetOperation.Builder)GetOperation.builder().setOperationId(this.id)).addAttribute(attribute)).build());
    }

    private void watchImpl() {
        logger.debug("Operation's watch iteration was started (OperationId: {})", (Object)this.id);
        ((CompletableFuture)((CompletableFuture)this.client.getOperation(((GetOperation.Builder)((GetOperation.Builder)((GetOperation.Builder)((GetOperation.Builder)((GetOperation.Builder)GetOperation.builder().setOperationId(this.id)).addAttribute("state")).addAttribute("brief_progress")).addAttribute("type")).addAttribute("operation_type")).build()).thenApply(this::getAndLogStatus)).thenCompose(status -> {
            if (status.isFinished()) {
                return this.getAndLogFailedJobs(this.id).handle((unused, ex) -> {
                    if (ex != null) {
                        logger.warn("Cannot get failed jobs info", ex);
                    }
                    this.watchResult.complete(null);
                    return null;
                });
            }
            return CompletableFuture.completedFuture(null);
        })).handle((unused, ex) -> {
            if (!this.watchResult.isDone()) {
                this.executorService.schedule(this::watchImpl, this.pingPeriod.toNanos(), TimeUnit.NANOSECONDS);
            }
            return null;
        });
    }

    private OperationStatus getAndLogStatus(YTreeNode getOperationResult) {
        OperationStatus status;
        Map attrs = getOperationResult.asMap();
        String state = ((YTreeNode)attrs.get("state")).stringValue();
        try {
            status = (OperationStatus)OperationStatus.R.fromName(state);
        }
        catch (IllegalArgumentException e) {
            status = OperationStatus.UNKNOWN;
        }
        String statusDescription = state;
        if (attrs.containsKey("brief_progress") && ((YTreeNode)attrs.get("brief_progress")).mapNode().containsKey("jobs")) {
            Instant buildTime;
            YTreeMapNode briefProgress = ((YTreeNode)attrs.get("brief_progress")).mapNode();
            YTreeMapNode progress = briefProgress.getOrThrow("jobs").mapNode();
            try {
                buildTime = Instant.parse(briefProgress.getOrThrow("build_time").stringValue());
            }
            catch (DateTimeParseException e) {
                buildTime = this.previousBriefProgressBuildTime;
            }
            if (buildTime.compareTo(this.previousBriefProgressBuildTime) > 0 && progress.containsKey("total")) {
                StringBuilder sb = new StringBuilder();
                if (progress.containsKey("running")) {
                    sb.append("running ").append(progress.getOrThrow("running").longValue()).append(", ");
                }
                if (progress.containsKey("completed")) {
                    YTreeNode node = progress.getOrThrow("completed");
                    long count = 0L;
                    if (node.isIntegerNode()) {
                        count = node.longValue();
                    } else if (node.isMapNode()) {
                        count = node.mapNode().getLong("total");
                    }
                    sb.append("completed ").append(count).append(", ");
                }
                sb.append("total ").append(progress.getOrThrow("total").longValue());
                sb.append(" (").append(state).append(")");
                statusDescription = sb.toString();
            }
            this.previousBriefProgressBuildTime = buildTime;
        }
        try {
            logger.info("Operation {} ({}): {}", new Object[]{this.id, ((YTreeNode)attrs.get("type")).stringValue(), statusDescription});
        }
        catch (Exception ex) {
            logger.info("Operation {}: {}", (Object)this.id, (Object)statusDescription);
        }
        return status;
    }

    private CompletableFuture<Void> getAndLogFailedJobs(GUID operationId) {
        return this.client.listJobs(((ListJobs.Builder)ListJobs.builder().setOperationId(operationId)).setState(JobState.Failed).setLimit(5L).build()).thenCompose(listJobsResult -> CompletableFuture.allOf(listJobsResult.getJobs().stream().map(j -> this.getAndLogFailedJob(operationId, (JobResult)j)).collect(Collectors.toList()).toArray(new CompletableFuture[0])));
    }

    private CompletableFuture<Void> getAndLogFailedJob(GUID operationId, JobResult job) {
        FailedJobInfo failedJobInfo = new FailedJobInfo(job.getId());
        if (job.getError().isPresent()) {
            this.traverseInnerErrors(job.getError().get().mapNode(), errorNode -> failedJobInfo.addErrorMessage(errorNode.getString("message")));
        }
        return CompletableFuture.completedFuture(failedJobInfo).thenCompose(info -> ((CompletableFuture)this.client.getJobStderr(new GetJobStderr(operationId, job.getId())).thenApply(getJobStderrResult -> {
            if (getJobStderrResult.getStderr().isPresent()) {
                failedJobInfo.setStderr(new String(getJobStderrResult.getStderr().get()));
            }
            return failedJobInfo;
        })).handle((result, ex) -> {
            if (ex != null) {
                logger.error("Failed to fetch job details: {}, exception: {}", (Object)job.getId(), ex);
            } else {
                logger.error(result.toString());
            }
            return null;
        }));
    }

    void traverseInnerErrors(YTreeMapNode errorNode, Consumer<YTreeMapNode> errorNodeConsumer) {
        YTreeNode node;
        errorNodeConsumer.accept(errorNode);
        Optional innerErrors = errorNode.get("inner_errors");
        if (innerErrors.isPresent() && (node = (YTreeNode)innerErrors.get()) instanceof YTreeListNode) {
            for (YTreeNode innerError : node.asList()) {
                this.traverseInnerErrors(innerError.mapNode(), errorNodeConsumer);
            }
        }
    }
}

