/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.YTableEntryType;
import tech.ytsaurus.core.common.YTsaurusProtobufFormat;
import tech.ytsaurus.core.operations.CloseableIterator;
import tech.ytsaurus.core.operations.OperationContext;
import tech.ytsaurus.core.operations.Yield;
import tech.ytsaurus.core.utils.ClassUtils;
import tech.ytsaurus.ysontree.YTreeStringNode;

public class ProtobufTableEntryType<T extends Message>
implements YTableEntryType<T> {
    private static final int CONTROL_ATTR_TABLE_INDEX = -1;
    private static final int CONTROL_ATTR_KEY_SWITCH = -2;
    private static final int CONTROL_ATTR_RANGE_INDEX = -3;
    private static final int CONTROL_ATTR_ROW_INDEX = -4;
    private final Message.Builder builder;
    private final boolean trackIndices;
    private final boolean isInputType;

    public ProtobufTableEntryType(Message.Builder messageBuilder, boolean trackIndices, boolean isInputType) {
        this.builder = messageBuilder;
        this.trackIndices = trackIndices;
        this.isInputType = isInputType;
    }

    @Override
    public YTreeStringNode format(FormatContext context) {
        ArrayList<Message.Builder> messageBuilders = new ArrayList<Message.Builder>();
        int tablesCount = this.isInputType ? context.getInputTableCount().orElseThrow(IllegalArgumentException::new) : context.getOutputTableCount().orElseThrow(IllegalArgumentException::new);
        for (int i = 0; i < tablesCount; ++i) {
            messageBuilders.add(this.builder);
        }
        return new YTsaurusProtobufFormat(messageBuilders).spec();
    }

    @Override
    public CloseableIterator<T> iterator(final InputStream input, final OperationContext context) {
        return new CloseableIterator<T>(){
            final CodedInputStream in;
            boolean hasNextChecked;
            @Nullable
            T next;
            int size;
            long rowIndex;
            int tableIndex;
            {
                this.in = CodedInputStream.newInstance((InputStream)input);
                this.hasNextChecked = false;
                this.size = 0;
                this.rowIndex = 0L;
                this.tableIndex = 0;
            }

            public boolean hasNext() {
                this.hasNextChecked = true;
                if (this.next != null) {
                    return true;
                }
                try {
                    if (this.in.isAtEnd()) {
                        return false;
                    }
                    ProtobufTableEntryType.this.builder.clear();
                    this.in.resetSizeCounter();
                    this.size = this.in.readFixed32();
                    if (ProtobufTableEntryType.this.trackIndices) {
                        ++this.rowIndex;
                    }
                    block8: while (this.size < 0) {
                        switch (this.size) {
                            case -2: {
                                this.size = this.in.readFixed32();
                                continue block8;
                            }
                            case -1: {
                                this.tableIndex = this.in.readFixed32();
                                this.size = this.in.readFixed32();
                                continue block8;
                            }
                            case -3: {
                                this.in.readFixed32();
                                this.size = this.in.readFixed32();
                                continue block8;
                            }
                            case -4: {
                                this.rowIndex = this.in.readFixed64();
                                this.size = this.in.readFixed32();
                                continue block8;
                            }
                        }
                        throw new RuntimeException("broken stream");
                    }
                    if (ProtobufTableEntryType.this.trackIndices) {
                        context.setRowIndex(this.rowIndex);
                        context.setTableIndex((long)this.tableIndex);
                    }
                    this.next = (Message)ClassUtils.castToType((Object)ProtobufTableEntryType.this.builder.mergeFrom(this.in.readRawBytes(this.size)).build());
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public T next() {
                if (!this.hasNextChecked && !this.hasNext()) {
                    throw new IllegalStateException();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                this.hasNextChecked = false;
                return ret;
            }

            public void close() throws Exception {
                input.close();
            }
        };
    }

    @Override
    public Yield<T> yield(final OutputStream[] output) {
        final CodedOutputStream[] writers = new CodedOutputStream[output.length];
        for (int i = 0; i < output.length; ++i) {
            writers[i] = CodedOutputStream.newInstance((OutputStream)output[i]);
        }
        return new Yield<T>(){

            public void yield(int index, Message value) {
                try {
                    byte[] messageBytes = value.toByteArray();
                    writers[index].writeFixed32NoTag(messageBytes.length);
                    writers[index].writeRawBytes(messageBytes);
                    writers[index].flush();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public void close() throws IOException {
                for (OutputStream stream : output) {
                    stream.close();
                }
            }
        };
    }
}

