/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import tech.ytsaurus.client.operations.Reducer;
import tech.ytsaurus.client.operations.Statistics;
import tech.ytsaurus.client.operations.StatisticsImpl;
import tech.ytsaurus.client.operations.YTableEntryType;
import tech.ytsaurus.client.operations.YtMainUtils;
import tech.ytsaurus.core.operations.CloseableIterator;
import tech.ytsaurus.core.operations.OperationContext;
import tech.ytsaurus.core.operations.Yield;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class ReduceMain {
    private ReduceMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        YtMainUtils.setTempDir();
        YtMainUtils.disableSystemOutput();
        OutputStream[] output = YtMainUtils.buildOutputStreams(args);
        Reducer reducer = (Reducer)YtMainUtils.construct(args);
        try {
            ReduceMain.applyReducer(reducer, System.in, output, new StatisticsImpl());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(2);
        }
        finally {
            System.exit(0);
        }
    }

    public static <I, O> void applyReducer(Reducer<I, O> reducer, InputStream in, OutputStream[] output, Statistics statistics) throws Exception {
        YTableEntryType inputType = reducer.inputType();
        YTableEntryType outputType = reducer.outputType();
        try (Statistics statistics2 = statistics;
             Yield yield = outputType.yield(output);){
            OperationContext context = new OperationContext();
            CloseableIterator it = inputType.iterator(in, context);
            reducer.start(yield, statistics);
            reducer.reduce((Iterator<I>)it, (Yield<O>)yield, statistics, context);
            it.forEachRemaining(tmp -> {});
            reducer.finish(yield, statistics);
        }
    }
}

