/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.CommandSpec;
import tech.ytsaurus.client.operations.EntityTableEntryType;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.JobIo;
import tech.ytsaurus.client.operations.MapperOrReducerSpec;
import tech.ytsaurus.client.operations.Reducer;
import tech.ytsaurus.client.operations.ReducerSpec;
import tech.ytsaurus.client.operations.SimpleUserOperationSpecBase;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.client.operations.UserJobSpec;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class ReduceSpec
extends SimpleUserOperationSpecBase
implements Spec {
    private final UserJobSpec reducerSpec;
    private final List<String> reduceBy;
    private final List<String> joinBy;
    private final List<String> sortBy;
    @Nullable
    private final JobIo jobIo;
    private final boolean enableKeyGuarantee;

    public ReduceSpec(List<YPath> inputTables, List<YPath> outputTables, List<String> reduceBy, String command) {
        this(inputTables, outputTables, reduceBy, new CommandSpec(command));
    }

    public ReduceSpec(List<YPath> inputTables, List<YPath> outputTables, List<String> reduceBy, Reducer<?, ?> reducer) {
        this(inputTables, outputTables, reduceBy, new ReducerSpec(reducer));
    }

    public ReduceSpec(List<YPath> inputTables, List<YPath> outputTables, List<String> reduceBy, UserJobSpec reducerSpec) {
        this(null, null, inputTables, outputTables, reduceBy, reducerSpec);
    }

    public ReduceSpec(@Nullable Integer jobCount, @Nullable DataSize maxDataSizePerJob, List<YPath> inputTables, List<YPath> outputTables, List<String> reduceBy, UserJobSpec reducerSpec) {
        this((BuilderBase<?>)((BuilderBase)((BuilderBase)((BuilderBase)((BuilderBase)((BuilderBase)ReduceSpec.builder().setJobCount(jobCount)).setMaxDataSizePerJob(maxDataSizePerJob)).setInputTables(inputTables)).setOutputTables(outputTables)).setReduceBy(reduceBy)).setReducerSpec(reducerSpec));
    }

    protected ReduceSpec(BuilderBase<?> builder) {
        super((SimpleUserOperationSpecBase.Builder<?>)builder);
        if (builder.reducerSpec == null) {
            throw new RuntimeException("reducer is not set");
        }
        this.reducerSpec = builder.reducerSpec;
        if (builder.joinBy.isEmpty() && builder.reduceBy.isEmpty()) {
            throw new RuntimeException("Neither reduceBy nor joinBy is set");
        }
        this.reduceBy = builder.reduceBy;
        this.joinBy = builder.joinBy;
        this.sortBy = builder.sortBy;
        if (this.reducerSpec instanceof MapperOrReducerSpec) {
            MapperOrReducerSpec mapperOrReducerSpec = (MapperOrReducerSpec)this.reducerSpec;
            this.jobIo = mapperOrReducerSpec.createJobIo(builder.jobIo);
            if (mapperOrReducerSpec.mapperOrReducer.outputType().getClass() == EntityTableEntryType.class) {
                TableSchema outputTableSchema = ((EntityTableEntryType)mapperOrReducerSpec.mapperOrReducer.outputType()).getTableSchema();
                this.getOutputTables().replaceAll(yPath -> yPath.withSchema(outputTableSchema.toYTree()));
            }
        } else {
            this.jobIo = builder.jobIo;
        }
        this.enableKeyGuarantee = builder.enableKeyGuarantee;
    }

    public Optional<JobIo> getJobIo() {
        return Optional.ofNullable(this.jobIo);
    }

    public List<String> getReduceBy() {
        return this.reduceBy;
    }

    public UserJobSpec getReducerSpec() {
        return this.reducerSpec;
    }

    public List<String> getJoinBy() {
        return this.joinBy;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        SpecUtils.createOutputTables(yt, specPreparationContext.getTransactionalOptions().orElse(null), this.getOutputTables(), this.getOutputTableAttributes());
        FormatContext formatContext = FormatContext.builder().setInputTableCount(this.getInputTables().size()).setOutputTableCount(this.getOutputTables().size()).build();
        return builder.beginMap().apply(b -> SpecUtils.addMapperOrReducerTitle(b, this.reducerSpec)).key("reducer").apply(b -> this.reducerSpec.prepare((YTreeBuilder)b, yt, specPreparationContext, formatContext)).key("reduce_by").value(this.reduceBy).when(!this.joinBy.isEmpty(), b -> b.key("join_by").value(this.joinBy)).when(!this.sortBy.isEmpty(), b -> b.key("sort_by").value(this.sortBy)).when(this.jobIo != null, b -> b.key("job_io").value((YTreeNode)this.jobIo.prepare())).when(!this.enableKeyGuarantee, b -> b.key("enable_key_guarantee").value(false)).apply(b -> this.dumpToSpec((YTreeBuilder)b, specPreparationContext)).endMap();
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>>
    extends SimpleUserOperationSpecBase.Builder<T> {
        @Nullable
        private UserJobSpec reducerSpec;
        @Nullable
        private JobIo jobIo;
        private List<String> reduceBy = new ArrayList<String>();
        private List<String> joinBy = new ArrayList<String>();
        private List<String> sortBy = new ArrayList<String>();
        private boolean enableKeyGuarantee = true;

        protected BuilderBase() {
        }

        public ReduceSpec build() {
            return new ReduceSpec(this);
        }

        public T setReducerSpec(UserJobSpec reducerSpec) {
            this.reducerSpec = reducerSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setReducerCommand(String command) {
            return this.setReducerSpec(new CommandSpec(command));
        }

        public T setReduceBy(List<String> reduceBy) {
            this.reduceBy = new ArrayList<String>(reduceBy);
            return (T)((BuilderBase)this.self());
        }

        public T setReduceBy(String ... reduceBy) {
            return this.setReduceBy(Arrays.asList(reduceBy));
        }

        public T setJoinBy(List<String> joinBy) {
            this.joinBy = new ArrayList<String>(joinBy);
            return (T)((BuilderBase)this.self());
        }

        public T setJoinBy(String ... joinBy) {
            return this.setJoinBy(Arrays.asList(joinBy));
        }

        public T setSortBy(List<String> sortBy) {
            this.sortBy = new ArrayList<String>(sortBy);
            return (T)((BuilderBase)this.self());
        }

        public T setSortBy(String ... sortBy) {
            return this.setSortBy(Arrays.asList(sortBy));
        }

        public T setJobIo(@Nullable JobIo jobIo) {
            this.jobIo = jobIo;
            return (T)((BuilderBase)this.self());
        }

        public T setEnableKeyGuarantee(boolean enableKeyGuarantee) {
            this.enableKeyGuarantee = enableKeyGuarantee;
            return (T)((BuilderBase)this.self());
        }
    }

    protected static class Builder
    extends BuilderBase<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

