/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ReducerWithKeyIterator<TInput, TKey>
implements Iterator<TInput> {
    private boolean eof = false;
    private boolean hasNextChecked = false;
    private TInput current;
    private TKey key;
    private TKey groupKey;
    private final Function<TInput, TKey> keyF;
    private final Iterator<TInput> iterator;

    public ReducerWithKeyIterator(Function<TInput, TKey> keyF, Iterator<TInput> iterator) {
        this.iterator = iterator;
        this.keyF = keyF;
        if (!iterator.hasNext()) {
            this.eof = true;
            this.current = null;
            this.key = null;
        } else {
            this.current = iterator.next();
            this.key = keyF.apply(this.current);
        }
    }

    @Nullable
    public TKey nextKey() {
        if (this.eof) {
            return null;
        }
        this.groupKey = this.key;
        return this.groupKey;
    }

    @Override
    public boolean hasNext() {
        this.hasNextChecked = true;
        if (this.eof) {
            return false;
        }
        return this.groupKey.equals(this.key);
    }

    @Override
    public TInput next() {
        if (!this.hasNextChecked && !this.hasNext()) {
            throw new IllegalStateException();
        }
        this.hasNextChecked = false;
        TInput ret = this.current;
        if (!this.iterator.hasNext()) {
            this.eof = true;
        } else {
            this.current = this.iterator.next();
            this.key = this.keyF.apply(this.current);
        }
        return ret;
    }
}

