/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.client.operations.SystemOperationSpecBase;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;

@NonNullApi
@NonNullFields
public class RemoteCopySpec
extends SystemOperationSpecBase
implements Spec {
    private final String cluster;
    @Nullable
    private final String network;
    @Nullable
    private final Boolean copyAttributes;

    public RemoteCopySpec(YPath source, YPath destination, String cluster) {
        this((BuilderBase)((BuilderBase)((BuilderBase)RemoteCopySpec.builder().setInputTables(source)).setOutputTable(destination)).setCluster(cluster));
    }

    protected <T extends BuilderBase<T>> RemoteCopySpec(BuilderBase<T> builder) {
        super(builder);
        this.cluster = Objects.requireNonNull(builder.cluster);
        this.network = builder.network;
        this.copyAttributes = builder.copyAttributes;
        Objects.requireNonNull(this.cluster);
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        SpecUtils.createOutputTables(yt, specPreparationContext.getTransactionalOptions().orElse(null), List.of(this.getOutputTable()), this.getOutputTableAttributes());
        return builder.beginMap().apply(b -> this.toTree((YTreeBuilder)b, specPreparationContext)).key("cluster_name").value(this.cluster).when(this.network != null, b -> b.key("network_name").value(this.network)).when(this.copyAttributes != null, b -> b.key("copy_attributes").value(this.copyAttributes)).endMap();
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>>
    extends SystemOperationSpecBase.Builder<T> {
        @Nullable
        private String cluster;
        @Nullable
        private String network;
        @Nullable
        private Boolean copyAttributes;

        public RemoteCopySpec build() {
            return new RemoteCopySpec(this);
        }

        public T setCluster(String cluster) {
            this.cluster = cluster;
            return (T)((BuilderBase)this.self());
        }

        public T setNetwork(@Nullable String network) {
            this.network = network;
            return (T)((BuilderBase)this.self());
        }

        public T setCopyAttributes(@Nullable Boolean copyAttributes) {
            this.copyAttributes = copyAttributes;
            return (T)((BuilderBase)this.self());
        }
    }

    protected static class Builder
    extends BuilderBase<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

