/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.FileWriter;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.JarsProcessor;
import tech.ytsaurus.client.operations.MapperOrReducer;
import tech.ytsaurus.client.request.CreateNode;
import tech.ytsaurus.client.request.GetFileFromCache;
import tech.ytsaurus.client.request.GetFileFromCacheResult;
import tech.ytsaurus.client.request.ListNode;
import tech.ytsaurus.client.request.MoveNode;
import tech.ytsaurus.client.request.PutFileToCache;
import tech.ytsaurus.client.request.RemoveNode;
import tech.ytsaurus.client.request.WriteFile;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.CypressNodeType;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class SingleUploadFromClassPathJarsProcessor
implements JarsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleUploadFromClassPathJarsProcessor.class);
    private static final String NATIVE_FILE_EXTENSION = "so";
    protected static final int DEFAULT_JARS_REPLICATION_FACTOR = 10;
    private final YPath jarsDir;
    @Nullable
    protected final YPath cacheDir;
    private final int fileCacheReplicationFactor;
    private final Duration uploadTimeout;
    private final boolean uploadNativeLibraries;
    private final Map<String, YPath> uploadedJars = new HashMap<String, YPath>();
    private final Map<String, Supplier<InputStream>> uploadMap = new HashMap<String, Supplier<InputStream>>();
    @Nullable
    private volatile Instant lastUploadTime;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SingleUploadFromClassPathJarsProcessor(YPath jarsDir, @Nullable YPath cacheDir) {
        this(jarsDir, cacheDir, false, Duration.ofMinutes(10L), 10);
    }

    public SingleUploadFromClassPathJarsProcessor(YPath jarsDir, @Nullable YPath cacheDir, boolean uploadNativeLibraries) {
        this(jarsDir, cacheDir, uploadNativeLibraries, Duration.ofMinutes(10L), 10);
    }

    public SingleUploadFromClassPathJarsProcessor(YPath jarsDir, @Nullable YPath cacheDir, boolean uploadNativeLibraries, Duration uploadTimeout) {
        this(jarsDir, cacheDir, uploadNativeLibraries, uploadTimeout, 10);
    }

    public SingleUploadFromClassPathJarsProcessor(YPath jarsDir, @Nullable YPath cacheDir, boolean uploadNativeLibraries, Duration uploadTimeout, @Nullable Integer fileCacheReplicationFactor) {
        this.jarsDir = jarsDir;
        this.cacheDir = cacheDir;
        this.uploadTimeout = uploadTimeout;
        this.uploadNativeLibraries = uploadNativeLibraries;
        this.fileCacheReplicationFactor = fileCacheReplicationFactor != null ? fileCacheReplicationFactor : 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<YPath> uploadJars(TransactionalClient yt, MapperOrReducer<?, ?> mapperOrReducer, boolean isLocalMode) {
        SingleUploadFromClassPathJarsProcessor singleUploadFromClassPathJarsProcessor = this;
        synchronized (singleUploadFromClassPathJarsProcessor) {
            try {
                this.uploadIfNeeded(yt.getRootClient(), isLocalMode);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return Set.copyOf(new HashSet<YPath>(this.uploadedJars.values()));
        }
    }

    protected void withJar(File jarFile, Consumer<File> consumer) {
        consumer.accept(jarFile);
    }

    protected void withClassPathDir(File classPathItem, byte[] jarBytes, BiConsumer<File, byte[]> consumer) {
        consumer.accept(classPathItem, jarBytes);
    }

    private boolean isUsingFileCache() {
        return this.cacheDir != null;
    }

    private void uploadIfNeeded(TransactionalClient yt, boolean isLocalMode) {
        this.uploadMap.clear();
        yt.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(this.jarsDir)).setType(CypressNodeType.MAP)).setRecursive(true)).setIgnoreExisting(true)).build()).join();
        if (!this.isUsingFileCache() && this.lastUploadTime != null && Instant.now().isBefore(Objects.requireNonNull(this.lastUploadTime).plus(this.uploadTimeout))) {
            return;
        }
        this.uploadedJars.clear();
        this.collectJars(yt);
        if (this.uploadNativeLibraries) {
            this.collectNativeLibs();
        }
        this.doUpload(yt, isLocalMode);
    }

    protected void writeFile(TransactionalClient yt, YPath path, InputStream data) {
        yt.createNode(new CreateNode(path, CypressNodeType.FILE)).join();
        FileWriter writer = yt.writeFile(((WriteFile.Builder)((WriteFile.Builder)WriteFile.builder().setPath(path.toString())).setComputeMd5(true)).build()).join();
        try {
            int count;
            byte[] bytes = new byte[65536];
            while ((count = data.read(bytes)) >= 0) {
                writer.write(bytes, 0, count);
                writer.readyEvent().join();
            }
            writer.close().join();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private YPath onFileChecked(TransactionalClient yt, @Nullable YPath path, String originalName, String md5, Supplier<InputStream> fileContent) {
        YPath res = path;
        Objects.requireNonNull(this.cacheDir);
        if (res == null) {
            YPath tmpPath = this.jarsDir.child(GUID.create().toString());
            LOGGER.info("Uploading {} to cache", (Object)originalName);
            this.writeFile(yt, tmpPath, fileContent.get());
            res = yt.putFileToCache(new PutFileToCache(tmpPath, this.cacheDir, md5)).join().getPath();
            yt.removeNode(((RemoveNode.Builder)((RemoveNode.Builder)((RemoveNode.Builder)RemoveNode.builder().setPath(tmpPath)).setRecursive(false)).setForce(true)).build()).join();
        }
        res = res.plusAdditionalAttribute("file_name", (Object)originalName).plusAdditionalAttribute("md5", (Object)md5).plusAdditionalAttribute("cache", this.cacheDir.toTree());
        return res;
    }

    protected List<CacheUploadTask> checkInCache(TransactionalClient yt, Map<String, Supplier<InputStream>> uploadMap) {
        Objects.requireNonNull(this.cacheDir);
        ArrayList<CacheUploadTask> tasks = new ArrayList<CacheUploadTask>();
        for (Map.Entry<String, Supplier<InputStream>> entry : uploadMap.entrySet()) {
            String md5 = SingleUploadFromClassPathJarsProcessor.calculateMd5(entry.getValue().get());
            CompletionStage future = yt.getFileFromCache(new GetFileFromCache(this.cacheDir, md5)).thenApply(GetFileFromCacheResult::getPath);
            tasks.add(new CacheUploadTask((CompletableFuture<Optional<YPath>>)future, md5, entry));
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkInCacheAndUpload(TransactionalClient yt, Map<String, Supplier<InputStream>> uploadMap) {
        List<CacheUploadTask> tasks = this.checkInCache(yt, uploadMap);
        int threadsCount = Math.min(uploadMap.size(), 5);
        ExecutorService executor = Executors.newFixedThreadPool(threadsCount);
        try {
            for (CacheUploadTask task : tasks) {
                task.result = executor.submit(() -> {
                    try {
                        Optional<YPath> path = task.cacheCheckResult.get();
                        return this.onFileChecked(yt, path.orElse(null), task.entry.getKey(), task.md5, task.entry.getValue());
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                });
            }
            for (CacheUploadTask task : tasks) {
                try {
                    Future<YPath> result = Objects.requireNonNull(task.result);
                    this.uploadedJars.put(task.entry.getKey(), result.get());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                    return;
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadToTemp(TransactionalClient yt, Map<String, Supplier<InputStream>> uploadMap, boolean isLocalMode) {
        int threadsCount = Math.min(uploadMap.size(), 5);
        ExecutorService executor = Executors.newFixedThreadPool(threadsCount);
        try {
            ArrayList<UploadTask> uploadTasks = new ArrayList<UploadTask>();
            for (Map.Entry<String, Supplier<InputStream>> entry : uploadMap.entrySet()) {
                String fileName = entry.getKey();
                UploadTask task = new UploadTask(fileName);
                task.result = executor.submit(() -> this.maybeUpload(yt, (Supplier)entry.getValue(), fileName, isLocalMode));
                uploadTasks.add(task);
            }
            for (UploadTask uploadTask : uploadTasks) {
                try {
                    YPath path = uploadTask.result.get();
                    this.uploadedJars.put(uploadTask.fileName, path);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                    return;
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private void doUpload(TransactionalClient yt, boolean isLocalMode) {
        if (this.uploadMap.isEmpty()) {
            return;
        }
        if (this.isUsingFileCache()) {
            this.checkInCacheAndUpload(yt, this.uploadMap);
        } else {
            this.uploadToTemp(yt, this.uploadMap, isLocalMode);
        }
        this.lastUploadTime = Instant.now();
    }

    private static void walk(File dir, Consumer<File> consumer) {
        consumer.accept(dir);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            SingleUploadFromClassPathJarsProcessor.walk(file, consumer);
        }
    }

    private File getParentFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            return parent;
        }
        String path = file.getPath();
        if (!path.contains("/") && !path.contains(".")) {
            return new File(".");
        }
        throw new RuntimeException(String.valueOf(this) + " has no parent");
    }

    private static String toHex(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (byte b : data) {
            result.append(DIGITS[(0xF0 & b) >>> 4]);
            result.append(DIGITS[0xF & b]);
        }
        return result.toString();
    }

    protected static String calculateMd5(InputStream stream) {
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[4096];
            while ((len = stream.read(bytes)) >= 0) {
                md.update(bytes, 0, len);
            }
            return SingleUploadFromClassPathJarsProcessor.toHex(md.digest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void collectJars(TransactionalClient yt) {
        yt.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(this.jarsDir)).setType(CypressNodeType.MAP)).setRecursive(true)).setIgnoreExisting(true)).build()).join();
        if (this.isUsingFileCache()) {
            yt.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(this.cacheDir)).setType(CypressNodeType.MAP)).setRecursive(true)).setIgnoreExisting(true)).build()).join();
        }
        Set existsJars = yt.listNode(new ListNode(this.jarsDir)).join().asList().stream().map(YTreeNode::stringValue).collect(Collectors.toSet());
        if (!this.isUsingFileCache() && !this.uploadedJars.isEmpty() && this.uploadedJars.values().stream().allMatch(p -> existsJars.contains(p.name()))) {
            return;
        }
        Set<String> classPathParts = this.getClassPathParts();
        for (String classPathPart : classPathParts) {
            File classPathItem = new File(classPathPart);
            if (SingleUploadFromClassPathJarsProcessor.fileHasExtension(classPathItem, "jar")) {
                if (!classPathItem.exists()) {
                    throw new IllegalStateException("Can't find " + String.valueOf(classPathItem));
                }
                if (!classPathItem.isFile()) continue;
                this.withJar(classPathItem, jar -> this.collectFile(() -> {
                    try {
                        return new FileInputStream((File)jar);
                    }
                    catch (FileNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                }, classPathItem.getName(), existsJars));
                continue;
            }
            if (!classPathItem.isDirectory()) continue;
            byte[] jarBytes = SingleUploadFromClassPathJarsProcessor.getClassPathDirJarBytes(classPathItem);
            this.withClassPathDir(classPathItem, jarBytes, (dir, bytes) -> this.collectFile(() -> new ByteArrayInputStream((byte[])bytes), dir.getName() + ".jar", existsJars));
        }
    }

    private static boolean fileHasExtension(File file, String extension) {
        String lowerExtension = "." + extension;
        return file.getName().toLowerCase().endsWith(lowerExtension);
    }

    private void collectNativeLibs() {
        String[] classPathParts;
        String libPath = System.getProperty("java.library.path");
        if (libPath == null) {
            throw new IllegalStateException("System property 'java.library.path' is null");
        }
        LOGGER.info("Searching native libs in " + libPath);
        for (String classPathPart : classPathParts = libPath.split(File.pathSeparator)) {
            File classPathItem = new File(classPathPart);
            if (!classPathItem.isDirectory()) continue;
            SingleUploadFromClassPathJarsProcessor.walk(classPathItem, elm -> {
                if (elm.isFile() && !Files.isSymbolicLink(elm.toPath()) && SingleUploadFromClassPathJarsProcessor.fileHasExtension(elm, NATIVE_FILE_EXTENSION)) {
                    this.withJar((File)elm, dll -> this.collectFile(() -> {
                        try {
                            return new FileInputStream((File)dll);
                        }
                        catch (FileNotFoundException ex) {
                            throw new RuntimeException(ex);
                        }
                    }, dll.getName(), Collections.emptySet()));
                }
            });
        }
    }

    private Set<String> getClassPathParts() {
        HashSet<String> classPathParts = new HashSet<String>();
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            throw new IllegalStateException("System property 'java.class.path' is null");
        }
        LOGGER.info("Searching libs in " + classPath);
        String[] classPathPartsRaw = classPath.split(File.pathSeparator);
        Attributes.Name classPathKey = new Attributes.Name("Class-Path");
        for (String classPathPart : classPathPartsRaw) {
            classPathParts.add(classPathPart);
            try {
                String[] fileList;
                Attributes a;
                File jarFile = new File(classPathPart);
                Manifest m = new JarFile(classPathPart).getManifest();
                if (m == null || !(a = m.getMainAttributes()).containsKey(classPathKey)) continue;
                for (String entity : fileList = a.getValue(classPathKey).split(" ")) {
                    try {
                        File jarFileChild = entity.startsWith("file:") ? new File(new URI(entity)) : new File(entity);
                        if (!jarFileChild.isAbsolute()) {
                            jarFileChild = new File(this.getParentFile(jarFile), entity);
                        }
                        if (!jarFileChild.exists()) continue;
                        classPathParts.add(jarFileChild.getPath());
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Cannot open : {}", (Object)entity, (Object)e);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return classPathParts;
    }

    private static String calculateYPath(Supplier<InputStream> fileContent, String originalName) {
        String md5 = SingleUploadFromClassPathJarsProcessor.calculateMd5(fileContent.get());
        String[] parts = originalName.split("\\.");
        String ext = parts.length < 2 ? "" : parts[parts.length - 1];
        return md5 + "." + ext;
    }

    private void collectFile(Supplier<InputStream> fileContent, String originalName, Set<String> existsFiles) {
        String fileName = SingleUploadFromClassPathJarsProcessor.calculateYPath(fileContent, originalName);
        boolean exists = existsFiles.contains(fileName);
        if (this.isUsingFileCache() || !exists) {
            if (!this.uploadMap.containsKey(originalName)) {
                this.uploadMap.put(originalName, fileContent);
            } else if (originalName.endsWith(".jar")) {
                String baseName = originalName.split("\\.")[0];
                this.uploadMap.put(baseName + "-" + SingleUploadFromClassPathJarsProcessor.calculateMd5(fileContent.get()) + ".jar", fileContent);
            }
        }
        if (!this.isUsingFileCache() && exists) {
            this.uploadedJars.put(originalName, this.jarsDir.child(fileName));
        }
    }

    private YPath maybeUpload(TransactionalClient yt, Supplier<InputStream> fileContent, String originalName, boolean isLocalMode) {
        YPath jarPath;
        String md5 = SingleUploadFromClassPathJarsProcessor.calculateMd5(fileContent.get());
        if (originalName.endsWith(NATIVE_FILE_EXTENSION)) {
            YPath dllDir = this.jarsDir.child(md5);
            yt.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(dllDir)).setType(CypressNodeType.MAP)).setRecursive(true)).setIgnoreExisting(true)).build()).join();
            jarPath = dllDir.child(originalName);
        } else {
            jarPath = this.jarsDir.child(SingleUploadFromClassPathJarsProcessor.calculateYPath(fileContent, originalName));
        }
        YPath tmpPath = this.jarsDir.child(GUID.create().toString());
        LOGGER.info("Uploading {} as {} using tmpPath {}", new Object[]{originalName, jarPath, tmpPath});
        int actualFileCacheReplicationFactor = isLocalMode ? 1 : this.fileCacheReplicationFactor;
        yt.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(tmpPath)).setType(CypressNodeType.FILE)).addAttribute("replication_factor", (YTreeNode)YTree.integerNode((long)actualFileCacheReplicationFactor))).setIgnoreExisting(true)).build()).join();
        this.writeFile(yt, tmpPath, fileContent.get());
        yt.moveNode(((MoveNode.Builder)((MoveNode.Builder)((MoveNode.Builder)((MoveNode.Builder)((MoveNode.Builder)MoveNode.builder().setSource(tmpPath.toString())).setDestination(jarPath.toString())).setPreserveAccount(true)).setRecursive(true)).setForce(true)).build()).join();
        return jarPath.plusAdditionalAttribute("file_name", (Object)originalName);
    }

    private static byte[] getClassPathDirJarBytes(File dir) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            JarOutputStream jar = new JarOutputStream(bytes){

                @Override
                public void putNextEntry(ZipEntry ze) throws IOException {
                    ze.setTime(-1L);
                    super.putNextEntry(ze);
                }
            };
            SingleUploadFromClassPathJarsProcessor.walk(dir, elm -> {
                String name = elm.getAbsolutePath().substring(dir.getAbsolutePath().length());
                if (name.length() > 0) {
                    try {
                        JarEntry entry = new JarEntry(name.substring(1).replace("\\", "/"));
                        jar.putNextEntry(entry);
                        if (elm.isFile()) {
                            Files.copy(elm.toPath(), jar);
                        }
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            });
            jar.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return bytes.toByteArray();
    }

    static class UploadTask {
        Future<YPath> result = new CompletableFuture<YPath>();
        String fileName;

        UploadTask(String fileName) {
            this.fileName = fileName;
        }
    }

    @NonNullFields
    @NonNullApi
    protected static class CacheUploadTask {
        final CompletableFuture<Optional<YPath>> cacheCheckResult;
        final String md5;
        final Map.Entry<String, Supplier<InputStream>> entry;
        @Nullable
        Future<YPath> result;

        public CacheUploadTask(CompletableFuture<Optional<YPath>> cacheCheckResult, String md5, Map.Entry<String, Supplier<InputStream>> entry) {
            this.cacheCheckResult = cacheCheckResult;
            this.md5 = md5;
            this.entry = entry;
        }
    }
}

